using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQueryStudent_QQ287307421 : Form
    {
        public FrmQueryStudent_QQ287307421()
        {
            InitializeComponent();
        }
        private void dtp_studentBirthday_ValueChanged(object sender, EventArgs e)
        {
            this.txt_studentBirthday.Text = this.dtp_studentBirthday.Value.ToShortDateString();
        } 
        private void txt_studentBirthday_DoubleClick(object sender, EventArgs e)
        {
            this.txt_studentBirthday.Text = "";
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.txt_studentNumber.Text != "")
            {
                sqlstr += "  and studentNumber like '%" + this.txt_studentNumber.Text + "%'";
            }
            if (this.txt_studentName.Text != "")
            {
                sqlstr += "  and studentName like '%" + this.txt_studentName.Text + "%'";
            }
            if (this.cb_studentClassNumber.SelectedValue.ToString() != "")
            {
                sqlstr += "  and studentClassNumber='" + this.cb_studentClassNumber.SelectedValue.ToString() + "'"; 
            }
            if (this.txt_studentBirthday.Text != "")
            {
                sqlstr += "  and convert(char(11),studentBirthday,20) ='" + this.txt_studentBirthday.Text + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllStudent_QQ287307421.GetStudent_QQ287307421(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_Student_QQ287307421.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQueryStudent_QQ287307421_Load(object sender, EventArgs e)
        {
            //ѯеİ༶Ϣ
            DataSet classInfoDs = BLL.bllClassInfo.getAllClassInfo();
            DataTable newDataTable_studentClassNumber = new DataTable();
            newDataTable_studentClassNumber.Columns.Add("classNumber");
            newDataTable_studentClassNumber.Columns.Add("className");

            foreach (DataRow oldDR in classInfoDs.Tables[0].Rows)
            {
                DataRow newDR = newDataTable_studentClassNumber.NewRow();
                newDR[0] = oldDR["classNumber"].ToString();
                newDR[1] = oldDR["className"].ToString();
                newDataTable_studentClassNumber.Rows.InsertAt(newDR, newDataTable_studentClassNumber.Rows.Count);
            }
            // Add your 'Select an item' option at the top  
            DataRow dr_studentClassNumber = newDataTable_studentClassNumber.NewRow();
            dr_studentClassNumber[0] = "";
            dr_studentClassNumber[1] = "ѡ";
            newDataTable_studentClassNumber.Rows.InsertAt(dr_studentClassNumber, 0);
            this.cb_studentClassNumber.DataSource = newDataTable_studentClassNumber;
            this.cb_studentClassNumber.DisplayMember = "className";
            this.cb_studentClassNumber.ValueMember = "classNumber";
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_Student_QQ287307421.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                String studentNumber = this.dataGridView_Student_QQ287307421.CurrentRow.Cells[0].Value.ToString();
                FrmEditStudent_QQ287307421 frmEditStudent_QQ287307421 = new FrmEditStudent_QQ287307421(studentNumber,this); 
                frmEditStudent_QQ287307421.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_Student_QQ287307421.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String studentNumber = this.dataGridView_Student_QQ287307421.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllStudent_QQ287307421.DelStudent_QQ287307421(studentNumber))
                        MessageBox.Show("ѧϢɾɹ!");
                    else
                        MessageBox.Show("ѧϢɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
