using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LoginFrame
{
    public partial class FrmQueryTeacher_QQ287307421 : Form
    {
        public FrmQueryTeacher_QQ287307421()
        {
            InitializeComponent();
        }
        private void dtp_teacherBirthday_ValueChanged(object sender, EventArgs e)
        {
            this.txt_teacherBirthday.Text = this.dtp_teacherBirthday.Value.ToShortDateString();
        } 
        private void txt_teacherBirthday_DoubleClick(object sender, EventArgs e)
        {
            this.txt_teacherBirthday.Text = "";
        }
        private void dtp_teacherArriveDate_ValueChanged(object sender, EventArgs e)
        {
            this.txt_teacherArriveDate.Text = this.dtp_teacherArriveDate.Value.ToShortDateString();
        } 
        private void txt_teacherArriveDate_DoubleClick(object sender, EventArgs e)
        {
            this.txt_teacherArriveDate.Text = "";
        }

        private void Btn_Query_Click(object sender, EventArgs e)
        {
            string sqlstr = " where 1=1 ";
            if (this.txt_teacherNumber.Text != "")
            {
                sqlstr += "  and teacherNumber like '%" + this.txt_teacherNumber.Text + "%'";
            }
            if (this.txt_teacherName.Text != "")
            {
                sqlstr += "  and teacherName like '%" + this.txt_teacherName.Text + "%'";
            }
            if (this.txt_teacherBirthday.Text != "")
            {
                sqlstr += "  and convert(char(11),teacherBirthday,20) ='" + this.txt_teacherBirthday.Text + "'"; 
            }
            if (this.txt_teacherArriveDate.Text != "")
            {
                sqlstr += "  and convert(char(11),teacherArriveDate,20) ='" + this.txt_teacherArriveDate.Text + "'"; 
            }
            HWhere.Text = sqlstr;
            BindData("");
        }
        public void BindData(string strClass)
        {
            int DataCount = 0;
            int NowPage = 1;
            int AllPage = 0;
            int PageSize = Convert.ToInt32(HPageSize.Text);
            switch (strClass)
            {
                case "next":
                    NowPage = Convert.ToInt32(HNowPage.Text) + 1;
                    break;
                case "up":
                    NowPage = Convert.ToInt32(HNowPage.Text) - 1;
                    break;
                case "end":
                    NowPage = Convert.ToInt32(HAllPage.Text);
                    break;
                case "refresh":
                    NowPage = Convert.ToInt32(HNowPage.Text);
                    break;
                default:
                    break;
            }
            DataTable dsLog = BLL.bllTeacher_QQ287307421.GetTeacher_QQ287307421(NowPage, PageSize, out AllPage, out DataCount, HWhere.Text);
            if (dsLog.Rows.Count == 0 || AllPage == 1)
            {
                LBEnd.Enabled = false;
                LBHome.Enabled = false;
                LBNext.Enabled = false;
                LBUp.Enabled = false;
            }
            else if (NowPage == 1)
            {
                LBHome.Enabled = false;
                LBUp.Enabled = false;
                LBNext.Enabled = true;
                LBEnd.Enabled = true;
            }
            else if (NowPage == AllPage)
            {
                LBHome.Enabled = true;
                LBUp.Enabled = true;
                LBNext.Enabled = false;
                LBEnd.Enabled = false;
            }
            else
            {
                LBEnd.Enabled = true;
                LBHome.Enabled = true;
                LBNext.Enabled = true;
                LBUp.Enabled = true;
            }
            this.dataGridView_Teacher_QQ287307421.DataSource = dsLog.DefaultView; 
            PageMes.Text = string.Format("[ÿҳ{0} {1}ҳ{2}ҳ   {3}]", PageSize, NowPage, AllPage, DataCount);
            HNowPage.Text = Convert.ToString(NowPage++);
            HAllPage.Text = AllPage.ToString();

            if (dsLog.Rows.Count > 0)
            {
                this.Btn_Update.Enabled = true;
                this.Btn_Del.Enabled = true;
            }
            else
            {
                this.Btn_Update.Enabled = false;
                this.Btn_Del.Enabled = false;
            }
        }

        /*ʼش*/
        private void FrmQueryTeacher_QQ287307421_Load(object sender, EventArgs e)
        {
        }
        private void LBHome_Click(object sender, EventArgs e)
        {
            BindData("");
        }
        private void LBUp_Click(object sender, EventArgs e)
        {
            BindData("up");
        }
        private void LBNext_Click(object sender, EventArgs e)
        {
            BindData("next");
        }
        private void LBEnd_Click(object sender, EventArgs e)
        {
            BindData("end");
        }

        private void Btn_Update_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_Teacher_QQ287307421.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                String teacherNumber = this.dataGridView_Teacher_QQ287307421.CurrentRow.Cells[0].Value.ToString();
                FrmEditTeacher_QQ287307421 frmEditTeacher_QQ287307421 = new FrmEditTeacher_QQ287307421(teacherNumber,this); 
                frmEditTeacher_QQ287307421.ShowDialog(); 
            }
        }

        private void Btn_Del_Click(object sender, EventArgs e)
        {
            if (((System.Windows.Forms.BaseCollection)(dataGridView_Teacher_QQ287307421.SelectedRows)).Count != 1)
            {
                MessageBox.Show("ѡһ", "ʾ", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
            }
            else
            {
                if ( MessageBox.Show("ȷɾ?", "ɾʾ", MessageBoxButtons.OKCancel) == DialogResult.OK)
                {
                    String teacherNumber = this.dataGridView_Teacher_QQ287307421.CurrentRow.Cells[0].Value.ToString();
                    if (BLL.bllTeacher_QQ287307421.DelTeacher_QQ287307421(teacherNumber))
                        MessageBox.Show("ʦϢɾɹ!");
                    else
                        MessageBox.Show("ʦϢɾʧ!");
                    BindData("refresh");
                }
            }
        } 
    }
}
