﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;



namespace Victao.Common
{
    public static class Function
    {

        /// <summary>

        ///  Javascript方式彈出消息對話框

        /// </summary>

        /// <param name="message">要彈出的消息內容</param>

        /// <param name="page">當前頁面,參數可以直接寫:this 或 Page</param>

        public static void Alert(string message, Page page)
        {

            page.ClientScript.RegisterStartupScript(page.GetType(), null, "alert('" + message + "');", true);

        }



                /// <summary>

        /// javascript彈出消息後，跳轉到指定的URL鏈接頁面  

        /// </summary>

        /// <param name="message">要彈出的消息內容</param>

        /// <param name="pageUrl">要跳轉到的頁面鏈接,站內鏈接請填寫相對路徑,站外的鏈接需要加上"http://",如"http://www.baidu.com"</param>

        /// <param name="page">當前頁面,參數可以直接寫:this 或 Page</param>

        public static void AlertAndGotoUrl(string message, string pageUrl, Page page)
        {

            string strScript = "alert('" + message + "');window.location.href='" + pageUrl + "';";

            page.ClientScript.RegisterStartupScript(page.GetType(), null, strScript, true);

        }



        
    }
}
