﻿using System;
using System.Configuration;
using System.Reflection;
namespace Victao.Factory
{
	/// <summary>
	/// 抽象工厂模式创建DAL。
	/// web.config 需要加入配置：(利用工厂模式+反射机制+缓存机制,实现动态创建不同的数据层对象接口) 
	/// DataCache类在导出代码的文件夹里
	/// <appSettings> 
	/// <add key="DAL" value="Victao.OleDbDAL" /> (这里的命名空间根据实际情况更改为自己项目的命名空间)
	/// </appSettings> 
	/// </summary>
	public sealed class DataAccess//<t>
	{
        private static readonly string AssemblyPath = "Victao.OleDbDAL";
		/// <summary>
		/// 创建TeacherInfo数据层接口。
		/// </summary>
		public static Victao.IDAL.ITeacherInfo CreateTeacherInfo()
		{
			string ClassNamespace = AssemblyPath +".TeacherInfo";
            return (Victao.IDAL.ITeacherInfo) Assembly.Load(AssemblyPath).CreateInstance(ClassNamespace);
		}

}
}