﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.OleDb;
using System.Data;
using System.Collections;
using System.Configuration;

namespace Victao.OleDbDAL
{
    public class OleDbHelper
    {
        private static string _conStr = "Provider=Microsoft.Jet.OleDb.4.0;Data Source=" + System.Web.HttpContext.Current.Server.MapPath(System.Configuration.ConfigurationManager.ConnectionStrings["constr"].ConnectionString);
        public OleDbHelper()
        {
        }

        public static int ExecuteNonQuery(string sql, params OleDbParameter[] para)
        {

            try
            {
                OleDbCommand cmd = new OleDbCommand();
                using (OleDbConnection _conn=new OleDbConnection(_conStr))
                {

                    PrepareCommand(cmd, _conn,null, CommandType.Text, sql, para);
                    int val = cmd.ExecuteNonQuery();
                    cmd.Parameters.Clear();
                    return val;
                }
            }
            catch
            {
                return 0;
                throw;
            }
        }

        public static int ExecuteTransaction(Hashtable SQLStrList)
        {
            using (OleDbConnection _conn = new OleDbConnection(_conStr))
            {
                _conn.Open();
                using (OleDbTransaction trans = _conn.BeginTransaction())
                {
                    OleDbCommand cmd = new OleDbCommand();
                    try
                    {
                        int count = 0;
                        //循环
                        foreach (DictionaryEntry myDE in SQLStrList)
                        {
                            string sql = myDE.Key.ToString();
                            OleDbParameter[] para = (OleDbParameter[])myDE.Value;
                            PrepareCommand(cmd, _conn,trans, CommandType.Text, sql,para);
                            count += cmd.ExecuteNonQuery();
                            cmd.Parameters.Clear();
                        }
                        trans.Commit();
                        return count;
                    }
                    catch
                    {
                        trans.Rollback();
                        return 0;
                        throw;
                    }
                }
            }
        }
        public static int ExecuteTransaction(List<string> sqllist)
        {
            
            OleDbCommand cmd = new OleDbCommand();
            OleDbConnection _conn = new OleDbConnection(_conStr);
            cmd.Connection = _conn;
            OleDbTransaction tran = _conn.BeginTransaction();
            cmd.Transaction = tran;
            try
            {
                int count = 0;
                for (int i = 0; i < sqllist.Count; i++)
                {
                    string strsql = sqllist[i];
                    if (strsql.Trim().Length > 1)
                    {
                        cmd.CommandText = strsql;
                        count += cmd.ExecuteNonQuery();
                    }
                }
                tran.Commit();
                return count;
            }
            catch
            {
                tran.Rollback();
                return 0;
            }
            finally
            {
                _conn.Close() ;
                _conn.Dispose();
            }
        }

        public static object ExecScalar(string sql, params OleDbParameter[] para)
        {
            try
            {
                OleDbCommand cmd = new OleDbCommand();
                using (OleDbConnection _conn = new OleDbConnection(_conStr))
                {
                    PrepareCommand(cmd, _conn,null, CommandType.Text, sql, para);
                    object obj = cmd.ExecuteScalar();
                    cmd.Parameters.Clear();
                    return obj;
                }
            }
            catch
            {
                return 0;
                throw;
            }
        }

        public static DataTable GetTable(string sql, DataTable dt, params OleDbParameter[] para)
        {
            try
            {
                OleDbCommand cmd = new OleDbCommand();
                using (OleDbConnection _conn = new OleDbConnection(_conStr))
                {
                    PrepareCommand(cmd, _conn,null, CommandType.Text, sql, para);
                    OleDbDataAdapter da = new OleDbDataAdapter(cmd);
                    da.Fill(dt);
                    cmd.Parameters.Clear();
                    return dt;
                }
            }
            catch
            {
                return null;
                throw;
            }
        }

        public static IDataReader GetReader(string sql, params OleDbParameter[] para)
        {
            OleDbConnection _conn = new OleDbConnection(_conStr);
            try
            {

                OleDbCommand cmd = new OleDbCommand();
                PrepareCommand(cmd, _conn, null, CommandType.Text, sql, para);
                OleDbDataReader rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();
                return rdr;
            }
            catch
            {
                throw;
            }
            finally
            {
                _conn.Close();
                _conn.Dispose();
            }
        }
        private static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, OleDbTransaction trans, CommandType commandType, string commandtext, OleDbParameter[] cmdParms)
        {
            if (conn.State != ConnectionState.Open)
                conn.Open();
            if (trans != null)
                cmd.Transaction = trans;
            cmd.CommandType = commandType;
            cmd.CommandText = commandtext;
            cmd.Connection = conn;
            cmd.CommandTimeout=60;
            if (cmdParms != null)
            {


                foreach (OleDbParameter parameter in cmdParms)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&
                        (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
        }

    }

}
