﻿<%@ Page Language="c#" %>

<%@ Import Namespace="FreeFineSoft.Tools" %>
<%@ Register Src="config.ascx" TagName="Config" TagPrefix="FCKeditor" %>
<FCKeditor:Config ID="Config" runat="server"></FCKeditor:Config>
<script runat="server">
    public void Page_Load()
    {
        if (!Config.CheckAuthentication())
        {
            Response.Write("验证超时，请刷新后台再尝试。");
            return;
        }
		
        try
        {
            string sPath = Server.UrlDecode(Server.MapPath(HttpContext.Current.Request.Form["sPath"]));
            string dPath = Server.UrlDecode(Server.MapPath(HttpContext.Current.Request.Form["dPath"]));

            #region 验证扩展名
            string sExt = System.IO.Path.GetExtension(sPath).ToLower();
            string dExt = System.IO.Path.GetExtension(dPath).ToLower();
            if (sExt != dExt)
            {
                Response.Write("生成失败，略图扩展名必须与原文件扩展名一致！");
                return;
            }
            #endregion

            int width = Convert.ToInt16(HttpContext.Current.Request.Form["width"]);
            int height = Convert.ToInt16(HttpContext.Current.Request.Form["height"]);
            string waterWords = HttpContext.Current.Request.Form["waterWords"];
            string model = HttpContext.Current.Request.Form["model"];
            if (System.IO.File.Exists(dPath))
            {
                Response.Write(String.Format("已存在名为 {0} 的文件，请换个文件名试试。", dPath.Substring(dPath.LastIndexOf("\\") + 1)));
                return;
            }
            GenerateThumbnail(sPath, dPath, waterWords, width, height, model);
            Response.Write("OK");
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }
    protected void GenerateThumbnail(string sPath, string dPath, string waterWords, int width, int height, string model)
    {
        Thumbnail.MakeThumbnail(sPath, dPath, width, height, (Thumbnail.Model)Enum.Parse(typeof(Thumbnail.Model), model, true));
        if (string.IsNullOrEmpty(waterWords)) return;

        string err = string.Empty;
        Thumbnail.DrawWords(dPath, waterWords, 0.66f, Thumbnail.ImagePosition.RigthBottom, true, out err);
        if (!string.IsNullOrEmpty(err))
        {
            throw new Exception(err);
        }
    }
</script>
