﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<MvcEnterprise.Models.DataSet1+ArticleRow>" %>
<%
	var viewName = Request.QueryString["viewname"];
	if (viewName == null || viewName.ToLower() == "articleview") viewName = string.Empty;
%>
<div class="Location">
	<%= Html.ActionLink(Language.Context.Global.HomePage, "Index")%>
	<%= ViewData["PageLocation"] %>
	<br class="clearfloat" />
</div>
<div>
	<% if (AdminService.AdminName == "admin")
	{
		Response.Write(Html.ActionLink("【编辑】", "ArticleEdit", "Admin", new { ID = Model.ID }, new { style = "color:#F00;font-weight:bold", target = "_blank" }));%>
	<%} %>
</div>
<div class="WebContent">
	<% if (!MembersService.CanAccess(Model.GroupID, Model.Exclusive))
	{
		Html.RenderPartial("partial_Page_NoRight");
	}
	else
	{%>
	<h1><%= Model.ArticleName %></h1>
	<div style="text-align: center">
		<%= Language.Context.Article.AddTime %><%= Model.AddTime.ToString("yyyy-MM-dd") %>
		&nbsp;<%= Language.Context.Article.ClickNumber %><%= Model.ClickNumber %>
	</div>
	<hr />
	<div style="text-align: center">
	<%Html.RenderPartial("Partial_ShowMovie", new Movie { Url = CustomFields.GetValue("Article", Model.ID, "视频：").Replace("视频：",String.Empty), Width = "640", Height = "480" }); %>
	</div>
	<%= Model.Content%>
	<%} %>
	<div style="text-align: center">
	<%
	var downloadfile = CustomFields.GetValue("Article", Model.ID, "附件：").Replace("附件：",String.Empty);
	if (!string.IsNullOrEmpty(downloadfile)) { Response.Write("附件：<a href='" + downloadfile + "'>点击下载</a>");}
	%>
	</div>
	<hr />
	<%
		var allModel=new ArticleService().GetAllvisible();
		var pModel = allModel.Where(m => m.ID < Model.ID && m.SortID == Model.SortID).FirstOrDefault();
		string pID = string.Empty,pName,nID = string.Empty,nName;
		if (pModel!=null)
		{
			pID=pModel.ID.ToString();
			pName=pModel.ArticleName;
		}
		else
		{
			pName= Language.Context.Global.NoneOther;
		}
		var nModel = allModel.Where(m => m.ID > Model.ID).LastOrDefault();
		if (nModel!=null)
		{
			nID=nModel.ID.ToString();
			nName=nModel.ArticleName;
		}
		else
		{
			nName= Language.Context.Global.NoneOther;
		}
	%>
	<div><%= Language.Context.Article.Tags %><%= Model.Tags %></div>
	<div><% Html.RenderPartial("partial_Favorites"); %></div>
	<ul class="ListTitle">
		<li><a href="<%= string.IsNullOrEmpty(pID) ? "javascript:;" : Url.Action("ArticleView",new {ID = pID, viewName = viewName}) %>"><%= Language.Context.Article.Prev %><%= pName %></a></li>
		<li><a href="<%= string.IsNullOrEmpty(nID) ? "javascript:;" : Url.Action("ArticleView",new {ID = nID, viewName = viewName}) %>"><%= Language.Context.Article.Next %><%= nName %></a></li>
	</ul>
</div>
