using System;
using System.Collections;
using System.Collections.Specialized;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Data.Common;
using System.Collections.Generic;
using System.Data.SqlClient;
namespace student.DBUtility
{
    /// <summary>
    /// ݷ
    /// </summary>
    public class DbHelperOleDb
    {
        private static string connectionString = PubConstant.DBConnectionString;

        #region ÷
        /// <summary>
        /// жǷĳĳֶ
        /// </summary>
        /// <param name="tableName"></param>
        /// <param name="columnName"></param>
        /// <returns>Ƿ</returns>
        public static bool ColumnExists(string tableName, string columnName)
        {
            string OleDb = "select count(1) from syscolumns where [id]=object_id('" + tableName + "') and [name]='" + columnName + "'";
            object res = GetSingle(OleDb);
            if (res == null)
            {
                return false;
            }
            return Convert.ToInt32(res) > 0;
        }
        public static int GetMaxID(string FieldName, string TableName)
        {
            string strOleDb = "select max(" + FieldName + ")+1 from " + TableName;
            object obj = DbHelperOleDb.GetSingle(strOleDb);
            if (obj == null)
            {
                return 1;
            }
            else
            {
                return int.Parse(obj.ToString());
            }
        }
        public static bool Exists(string strOleDb)
        {
            object obj = DbHelperOleDb.GetSingle(strOleDb);
            int cmdresult;
            if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
            {
                cmdresult = 0;
            }
            else
            {
                cmdresult = int.Parse(obj.ToString());
            }
            if (cmdresult == 0)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="TableName"></param>
        /// <returns></returns>
        public static bool TabExists(string TableName)
        {
            string strOleDb = "select count(*) from sysobjects where id = object_id(N'[" + TableName + "]') and OBJECTPROPERTY(id, N'IsUserTable') = 1";
            //string strOleDb = "SELECT count(*) FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[" + TableName + "]') AND type in (N'U')";
            object obj = DbHelperOleDb.GetSingle(strOleDb);
            int cmdresult;
            if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
            {
                cmdresult = 0;
            }
            else
            {
                cmdresult = int.Parse(obj.ToString());
            }
            if (cmdresult == 0)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        public static bool Exists(string strOleDb, params   OleDbParameter[] cmdParms)
        {
            object obj = DbHelperOleDb.GetSingle(strOleDb, cmdParms);
            int cmdresult;
            if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
            {
                cmdresult = 0;
            }
            else
            {
                cmdresult = int.Parse(obj.ToString());
            }
            if (cmdresult == 0)
            {
                return false;
            }
            else
            {
                return true;
            }
        }

        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="tblName"></param>
        /// <param name="fldName">ֶ</param>
        /// <param name="strGetFields">ȡֶ</param>
        /// <param name="PageSize">ҳС</param>
        /// <param name="PageIndex">ҳ</param>
        /// <param name="orderType">ʽ,true=</param>
        /// <param name="strWhere">whereӾ䣬ؼ'where'</param>
        /// <param name="ReCount">¼</param>
        /// <returns></returns>
        public static DataSet GetPageList(string tblName, string fldName, string strGetFields, int PageSize, int PageIndex, bool orderType, string strWhere, ref int ReCount)
        {
            OleDbParameter[] pars = new OleDbParameter[] {
                new  OleDbParameter("@tblName", tblName),
                new OleDbParameter("@fldName", fldName),
                new OleDbParameter("@strGetFields", strGetFields),
                new OleDbParameter("@PageSize", PageSize),
                new OleDbParameter("@PageIndex", PageIndex),
                new OleDbParameter("@OrderType", orderType ? 0 : 1),
                new OleDbParameter("@strWhere", strWhere),
                new OleDbParameter("@Count", ReCount)
            };
            pars[7].Direction = ParameterDirection.Output;

            DataSet ds = RunProcedure("up_DataPager", pars, "ds");
            ReCount = (int)pars[7].Value;
            return ds;
        }

        /// <summary>
        /// ʹIdҳ
        /// </summary>
        /// <param name="tblName"></param>
        /// <param name="strGetFields">ȡֶ</param>
        /// <param name="PageSize">ҳС</param>
        /// <param name="PageIndex">ҳ</param>
        /// <param name="strWhere">whereӾ</param>
        /// <param name="ReCount">¼</param>
        /// <returns></returns>
        public static DataSet GetPageList(string tblName, string strGetFields, int PageSize, int PageIndex, string strWhere, ref int ReCount)
        {
            return GetPageList(tblName, "Id", strGetFields, PageSize, PageIndex, false, strWhere, ref ReCount);
        }

        /// <summary>
        /// ѯҳ
        /// </summary>
        /// <param name="tblName"></param>
        /// <param name="fldName"></param>
        /// <param name="pageSize"></param>
        /// <param name="page"></param>
        /// <param name="fldSort"></param>
        /// <param name="Sort"></param>
        /// <param name="strCondition"></param>
        /// <param name="ID"></param>
        /// <param name="Dist"></param>
        /// <param name="pageCount"></param>
        /// <param name="Counts"></param>
        /// <returns></returns>
        public static DataSet GetPageListCommon(string tblName, string fldName, int pageSize, int page, string fldSort, int Sort, string strCondition, string ID, int Dist, ref int pageCount, ref int Counts)
        {
            OleDbParameter[] pars = new OleDbParameter[] {
                new OleDbParameter("@tblName", tblName),
                new OleDbParameter("@fldName", fldName),
                new OleDbParameter("@pageSize", pageSize),
                new OleDbParameter("@page", page),
                new OleDbParameter("@fldSort", fldSort),
                new OleDbParameter("@Sort", Sort),
                new OleDbParameter("@strCondition", strCondition),
                new OleDbParameter("@ID", ID),
                new OleDbParameter("@Dist", Dist),
                new OleDbParameter("@pageCount", pageCount),
                new OleDbParameter("@Counts", Counts)
            };
            pars[9].Direction = ParameterDirection.Output;
            pars[10].Direction = ParameterDirection.Output;

            DataSet ds = RunProcedure("up_DataPagerCommon", pars, "ds");
            pageCount = (int)pars[10].Value;
            Counts = (int)pars[10].Value;
            return ds;
        }
        #endregion

        #region  ִмOleDb

        /// <summary>
        /// ִOleDb䣬Ӱļ¼
        /// </summary>
        /// <param name="OleDbString">OleDb</param>
        /// <returns>Ӱļ¼</returns>
        public static int ExecuteOleDb(string OleDbString)
        {
            using ( OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand(OleDbString, connection))
                {
                    try
                    {
                        connection.Open();
                        int rows = cmd.ExecuteNonQuery();
                        return rows;
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        connection.Close();
                        throw e;
                    }
                }
            }
        }

        public static int ExecuteOleDbyTime(string OleDbString, int Times)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand(OleDbString, connection))
                {
                    try
                    {
                        connection.Open();
                        cmd.CommandTimeout = Times;
                        int rows = cmd.ExecuteNonQuery();
                        return rows;
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        connection.Close();
                        throw e;
                    }
                }
            }
        }

        /// <summary>
        /// ִжOleDb䣬ʵݿ
        /// </summary>
        /// <param name="OleDbStringList">OleDb</param>		
        public static int ExecuteOleDbTran(List<String> OleDbStringList)
        {
            using (OleDbConnection conn = new OleDbConnection(connectionString))
            {
                conn.Open();
                OleDbCommand cmd = new OleDbCommand();
                cmd.Connection = conn;
                OleDbTransaction tx = conn.BeginTransaction();
                cmd.Transaction = tx;
                try
                {
                    int count = 0;
                    for (int n = 0; n < OleDbStringList.Count; n++)
                    {
                        string strOleDb = OleDbStringList[n];
                        if (strOleDb.Trim().Length > 1)
                        {
                            cmd.CommandText = strOleDb;
                            count += cmd.ExecuteNonQuery();
                        }
                    }
                    tx.Commit();
                    return count;
                }
                catch
                {
                    tx.Rollback();
                    return 0;
                }
            }
        }
        /// <summary>
        /// ִдһ洢̲ĵOleDb䡣
        /// </summary>
        /// <param name="OleDbString">OleDb</param>
        /// <param name="content">,һֶǸʽӵ£ţͨʽ</param>
        /// <returns>Ӱļ¼</returns>
        public static int ExecuteOleDb(string OleDbString, string content)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                OleDbCommand cmd = new OleDbCommand(OleDbString, connection);
                OleDbParameter myParameter =new OleDbParameter("@content", DbType.String);
                myParameter.Value = content;
                cmd.Parameters.Add(myParameter);
                try
                {
                    connection.Open();
                    int rows = cmd.ExecuteNonQuery();
                    return rows;
                }
                catch (System.Data.SqlClient.SqlException e)
                {
                    throw e;
                }
                finally
                {
                    cmd.Dispose();
                    connection.Close();
                }
            }
        }
        /// <summary>
        /// ִдһ洢̲ĵOleDb䡣
        /// </summary>
        /// <param name="OleDbString">OleDb</param>
        /// <param name="content">,һֶǸʽӵ£ţͨʽ</param>
        /// <returns>Ӱļ¼</returns>
        public static object ExecuteOleDbGet(string OleDbString, string content)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                OleDbCommand cmd = new OleDbCommand(OleDbString, connection);
                OleDbParameter myParameter = new OleDbParameter("@content", DbType.String);
                myParameter.Value = content;
                cmd.Parameters.Add(myParameter);
                try
                {
                    connection.Open();
                    object obj = cmd.ExecuteScalar();
                    if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                    {
                        return null;
                    }
                    else
                    {
                        return obj;
                    }
                }
                catch (System.Data.SqlClient.SqlException e)
                {
                    throw e;
                }
                finally
                {
                    cmd.Dispose();
                    connection.Close();
                }
            }
        }
        ///// <summary>
        ///// ݿͼʽֶ(Ƶһʵ)
        ///// </summary>
        ///// <param name="strOleDb">OleDb</param>
        ///// <param name="fs">ͼֽ,ݿֶΪimage</param>
        ///// <returns>Ӱļ¼</returns>
        //public static int ExecuteOleDbInsertImg(string strOleDb, byte[] fs)
        //{
        //    using (OleDbConnection connection = new OleDbConnection(connectionString))
        //    {
        //        OleDbCommand cmd = new OleDbCommand(strOleDb, connection);
        //        OleDbParameter myParameter =new OleDbParameter("@fs", DbType.Image);
        //        myParameter.Value = fs;
        //        cmd.Parameters.Add(myParameter);
        //        try
        //        {
        //            connection.Open();
        //            int rows = cmd.ExecuteNonQuery();
        //            return rows;
        //        }
        //        catch (System.Data.SqlClient.SqlException e)
        //        {
        //            throw e;
        //        }
        //        finally
        //        {
        //            cmd.Dispose();
        //            connection.Close();
        //        }
        //    }
        //}

        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="OleDbString">ѯ</param>
        /// <returns>ѯobject</returns>
        public static object GetSingle(string OleDbString)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand(OleDbString, connection))
                {
                    try
                    {
                        connection.Open();
                        object obj = cmd.ExecuteScalar();
                        if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                        {
                            return null;
                        }
                        else
                        {
                            return obj;
                        }
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        connection.Close();
                        throw e;
                    }
                }
            }
        }
        public static object GetSingle(string OleDbString, int Times)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand(OleDbString, connection))
                {
                    try
                    {
                        connection.Open();
                        cmd.CommandTimeout = Times;
                        object obj = cmd.ExecuteScalar();
                        if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                        {
                            return null;
                        }
                        else
                        {
                            return obj;
                        }
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        connection.Close();
                        throw e;
                    }
                }
            }
        }
        /// <summary>
        /// ִвѯ䣬OleDbDataReader ( ע⣺ø÷һҪOleDbDataReaderClose )
        /// </summary>
        /// <param name="strOleDb">ѯ</param>
        /// <returns>OleDbDataReader</returns>
        public static OleDbDataReader ExecuteReader(string strOleDb)
        {
            OleDbConnection connection = new OleDbConnection(connectionString);
            OleDbCommand cmd = new OleDbCommand(strOleDb, connection);
            try
            {
                connection.Open();
               OleDbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                return myReader;
            }
            catch (System.Data.SqlClient.SqlException e)
            {
                throw e;
            }

        }
        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="OleDbString">ѯ</param>
        /// <returns>DataSet</returns>
        public static DataSet Query(string OleDbString)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                DataSet ds = new DataSet();
                try
                {
                    connection.Open();
                    OleDbDataAdapter command = new OleDbDataAdapter(OleDbString, connection);
                    command.Fill(ds, "ds");
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    throw new Exception(ex.Message);
                }
                return ds;
            }
        }
        public static DataSet Query(string OleDbString, int Times)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                DataSet ds = new DataSet();
                try
                {
                    connection.Open();
                    OleDbDataAdapter command = new OleDbDataAdapter(OleDbString, connection);
                    command.SelectCommand.CommandTimeout = Times;
                    command.Fill(ds, "ds");
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    throw new Exception(ex.Message);
                }
                return ds;
            }
        }



        #endregion

        #region ִдOleDb

        /// <summary>
        /// ִOleDb䣬Ӱļ¼
        /// </summary>
        /// <param name="OleDbString">OleDb</param>
        /// <returns>Ӱļ¼</returns>
        public static int ExecuteOleDb(string OleDbString, params OleDbParameter[] cmdParms)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand())
                {
                    try
                    {
                        PrepareCommand(cmd, connection, null, OleDbString, cmdParms);
                        int rows = cmd.ExecuteNonQuery();
                        cmd.Parameters.Clear();
                        return rows;
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        throw e;
                    }
                }
            }
        }


        /// <summary>
        /// ִжOleDb䣬ʵݿ
        /// </summary>
        /// <param name="OleDbStringList">OleDbĹϣkeyΪOleDb䣬valueǸOleDbParameter[]</param>
        public static void ExecuteOleDbTran(Hashtable OleDbStringList)
        {
            using (OleDbConnection conn = new OleDbConnection(connectionString))
            {
                conn.Open();
                using (OleDbTransaction trans = conn.BeginTransaction())
                {
                    OleDbCommand cmd = new OleDbCommand();
                    try
                    {
                        //ѭ
                        foreach (DictionaryEntry myDE in OleDbStringList)
                        {
                            string cmdText = myDE.Key.ToString();
                            OleDbParameter[] cmdParms = (OleDbParameter[])myDE.Value;
                            PrepareCommand(cmd, conn, trans, cmdText, cmdParms);
                            int val = cmd.ExecuteNonQuery();
                            cmd.Parameters.Clear();
                        }
                        trans.Commit();
                    }
                    catch
                    {
                        trans.Rollback();
                        throw;
                    }
                }
            }
        }
        ///// <summary>
        ///// ִжOleDb䣬ʵݿ
        ///// </summary>
        ///// <param name="OleDbStringList">OleDbĹϣkeyΪOleDb䣬valueǸOleDbParameter[]</param>
        //public static int ExecuteOleDbTran(System.Collections.Generic.List<CommandInfo> cmdList)
        //{
        //    using (OleDbConnection conn = new OleDbConnection(connectionString))
        //    {
        //        conn.Open();
        //        using (OleDbTransaction trans = conn.BeginTransaction())
        //        {
        //            OleDbCommand cmd = new OleDbCommand();
        //            try
        //            {
        //                int count = 0;
        //                //ѭ
        //                foreach (CommandInfo myDE in cmdList)
        //                {
        //                    string cmdText = myDE.CommandText;
        //                    OleDbParameter[] cmdParms = (OleDbParameter[])myDE.Parameters;
        //                    PrepareCommand(cmd, conn, trans, cmdText, cmdParms);

        //                    if (myDE.EffentNextType == EffentNextType.WhenHaveContine || myDE.EffentNextType == EffentNextType.WhenNoHaveContine)
        //                    {
        //                        if (myDE.CommandText.ToLower().IndexOf("count(") == -1)
        //                        {
        //                            trans.Rollback();
        //                            return 0;
        //                        }

        //                        object obj = cmd.ExecuteScalar();
        //                        bool isHave = false;
        //                        if (obj == null && obj == DBNull.Value)
        //                        {
        //                            isHave = false;
        //                        }
        //                        isHave = Convert.ToInt32(obj) > 0;

        //                        if (myDE.EffentNextType == EffentNextType.WhenHaveContine && !isHave)
        //                        {
        //                            trans.Rollback();
        //                            return 0;
        //                        }
        //                        if (myDE.EffentNextType == EffentNextType.WhenNoHaveContine && isHave)
        //                        {
        //                            trans.Rollback();
        //                            return 0;
        //                        }
        //                        continue;
        //                    }
        //                    int val = cmd.ExecuteNonQuery();
        //                    count += val;
        //                    if (myDE.EffentNextType == EffentNextType.ExcuteEffectRows && val == 0)
        //                    {
        //                        trans.Rollback();
        //                        return 0;
        //                    }
        //                    cmd.Parameters.Clear();
        //                }
        //                trans.Commit();
        //                return count;
        //            }
        //            catch
        //            {
        //                trans.Rollback();
        //                throw;
        //            }
        //        }
        //    }
        //}
        ///// <summary>
        ///// ִжOleDb䣬ʵݿ
        ///// </summary>
        ///// <param name="OleDbStringList">OleDbĹϣkeyΪOleDb䣬valueǸOleDbParameter[]</param>
        //public static void ExecuteOleDbTranWithIndentity(System.Collections.Generic.List<CommandInfo> OleDbStringList)
        //{
        //    using (OleDbConnection conn = new OleDbConnection(connectionString))
        //    {
        //        conn.Open();
        //        using (OleDbTransaction trans = conn.BeginTransaction())
        //        {
        //            OleDbCommand cmd = new OleDbCommand();
        //            try
        //            {
        //                int indentity = 0;
        //                //ѭ
        //                foreach (CommandInfo myDE in OleDbStringList)
        //                {
        //                    string cmdText = myDE.CommandText;
        //                    OleDbParameter[] cmdParms = (OleDbParameter[])myDE.Parameters;
        //                    foreach (OleDbParameter q in cmdParms)
        //                    {
        //                        if (q.Direction == ParameterDirection.InputOutput)
        //                        {
        //                            q.Value = indentity;
        //                        }
        //                    }
        //                    PrepareCommand(cmd, conn, trans, cmdText, cmdParms);
        //                    int val = cmd.ExecuteNonQuery();
        //                    foreach (OleDbParameter q in cmdParms)
        //                    {
        //                        if (q.Direction == ParameterDirection.Output)
        //                        {
        //                            indentity = Convert.ToInt32(q.Value);
        //                        }
        //                    }
        //                    cmd.Parameters.Clear();
        //                }
        //                trans.Commit();
        //            }
        //            catch
        //            {
        //                trans.Rollback();
        //                throw;
        //            }
        //        }
        //    }
        //}
        /// <summary>
        /// ִжOleDb䣬ʵݿ
        /// </summary>
        /// <param name="OleDbStringList">OleDbĹϣkeyΪOleDb䣬valueǸOleDbParameter[]</param>
        public static void ExecuteOleDbTranWithIndentity(Hashtable OleDbStringList)
        {
            using (OleDbConnection conn = new OleDbConnection(connectionString))
            {
                conn.Open();
                using (OleDbTransaction trans = conn.BeginTransaction())
                {
                    OleDbCommand cmd = new OleDbCommand();
                    try
                    {
                        int indentity = 0;
                        //ѭ
                        foreach (DictionaryEntry myDE in OleDbStringList)
                        {
                            string cmdText = myDE.Key.ToString();
                            OleDbParameter[] cmdParms = (OleDbParameter[])myDE.Value;
                            foreach (OleDbParameter q in cmdParms)
                            {
                                if (q.Direction == ParameterDirection.InputOutput)
                                {
                                    q.Value = indentity;
                                }
                            }
                            PrepareCommand(cmd, conn, trans, cmdText, cmdParms);
                            int val = cmd.ExecuteNonQuery();
                            foreach (OleDbParameter q in cmdParms)
                            {
                                if (q.Direction == ParameterDirection.Output)
                                {
                                    indentity = Convert.ToInt32(q.Value);
                                }
                            }
                            cmd.Parameters.Clear();
                        }
                        trans.Commit();
                    }
                    catch
                    {
                        trans.Rollback();
                        throw;
                    }
                }
            }
        }
        /// <summary>
        /// ִһѯ䣬زѯobject
        /// </summary>
        /// <param name="OleDbString">ѯ</param>
        /// <returns>ѯobject</returns>
        public static object GetSingle(string OleDbString, params OleDbParameter[] cmdParms)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                using (OleDbCommand cmd = new OleDbCommand())
                {
                    try
                    {
                        PrepareCommand(cmd, connection, null, OleDbString, cmdParms);
                        object obj = cmd.ExecuteScalar();
                        cmd.Parameters.Clear();
                        if ((Object.Equals(obj, null)) || (Object.Equals(obj, System.DBNull.Value)))
                        {
                            return null;
                        }
                        else
                        {
                            return obj;
                        }
                    }
                    catch (System.Data.SqlClient.SqlException e)
                    {
                        throw e;
                    }
                }
            }
        }

        /// <summary>
        /// ִвѯ䣬OleDbDataReader ( ע⣺ø÷һҪOleDbDataReaderClose )
        /// </summary>
        /// <param name="strOleDb">ѯ</param>
        /// <returns>OleDbDataReader</returns>
        public static OleDbDataReader ExecuteReader(string OleDbString, params OleDbParameter[] cmdParms)
        {
            OleDbConnection connection = new OleDbConnection(connectionString);
            OleDbCommand cmd = new OleDbCommand();
            try
            {
                PrepareCommand(cmd, connection, null, OleDbString, cmdParms);
                OleDbDataReader myReader = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                cmd.Parameters.Clear();
                return myReader;
            }
            catch (System.Data.SqlClient.SqlException e)
            {
                throw e;
            }
            //			finally
            //			{
            //				cmd.Dispose();
            //				connection.Close();
            //			}	

        }

        /// <summary>
        /// ִвѯ䣬DataSet
        /// </summary>
        /// <param name="OleDbString">ѯ</param>
        /// <returns>DataSet</returns>
        public static DataSet Query(string OleDbString, params OleDbParameter[] cmdParms)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                OleDbCommand cmd = new OleDbCommand();
                PrepareCommand(cmd, connection, null, OleDbString, cmdParms);
                using (OleDbDataAdapter da = new OleDbDataAdapter(cmd))
                {
                    DataSet ds = new DataSet();
                    try
                    {
                        da.Fill(ds, "ds");
                        cmd.Parameters.Clear();
                    }
                    catch (System.Data.SqlClient.SqlException ex)
                    {
                        throw new Exception(ex.Message);
                    }
                    return ds;
                }
            }
        }


        private static void PrepareCommand(OleDbCommand cmd, OleDbConnection conn, OleDbTransaction trans, string cmdText, OleDbParameter[] cmdParms)
        {
            if (conn.State != ConnectionState.Open)
                conn.Open();
            cmd.Connection = conn;
            cmd.CommandText = cmdText;
            if (trans != null)
                cmd.Transaction = trans;
            cmd.CommandType = CommandType.Text;//cmdType;
            if (cmdParms != null)
            {


                foreach (OleDbParameter parameter in cmdParms)
                {
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&
                        (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    cmd.Parameters.Add(parameter);
                }
            }
        }

        #endregion

        #region 洢̲

        /// <summary>
        /// ִд洢̣OleDbDataReader ( ע⣺ø÷һҪOleDbDataReaderClose )
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>OleDbDataReader</returns>
        public static OleDbDataReader RunProcedure(string storedProcName, IDataParameter[] parameters)
        {
            OleDbConnection connection = new OleDbConnection(connectionString);
            OleDbDataReader returnReader;
            connection.Open();
            OleDbCommand command = BuildQueryCommand(connection, storedProcName, parameters);
            command.CommandType = CommandType.StoredProcedure;
            returnReader = command.ExecuteReader(CommandBehavior.CloseConnection);
            return returnReader;

        }


        /// <summary>
        /// ִд洢
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <param name="tableName">DataSetеı</param>
        /// <returns>DataSet</returns>
        public static DataSet RunProcedure(string storedProcName, IDataParameter[] parameters, string tableName)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                DataSet dataSet = new DataSet();
                connection.Open();
                OleDbDataAdapter OleDbDA = new OleDbDataAdapter();
                OleDbDA.SelectCommand = BuildQueryCommand(connection, storedProcName, parameters);
                OleDbDA.Fill(dataSet, tableName);
                connection.Close();
                return dataSet;
            }
        }
        public static DataSet RunProcedure(string storedProcName, IDataParameter[] parameters, string tableName, int Times)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                DataSet dataSet = new DataSet();
                connection.Open();
                OleDbDataAdapter OleDbDA = new OleDbDataAdapter();
                OleDbDA.SelectCommand = BuildQueryCommand(connection, storedProcName, parameters);
                OleDbDA.SelectCommand.CommandTimeout = Times;
                OleDbDA.Fill(dataSet, tableName);
                connection.Close();
                return dataSet;
            }
        }


        /// <summary>
        ///  OleDbCommand (һһֵ)
        /// </summary>
        /// <param name="connection">ݿ</param>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>OleDbCommand</returns>
        private static OleDbCommand BuildQueryCommand(OleDbConnection connection, string storedProcName, IDataParameter[] parameters)
        {
            OleDbCommand command = new OleDbCommand(storedProcName, connection);
            command.CommandType = CommandType.StoredProcedure;
            foreach (OleDbParameter parameter in parameters)
            {
                if (parameter != null)
                {
                    // δֵ,DBNull.Value.
                    if ((parameter.Direction == ParameterDirection.InputOutput || parameter.Direction == ParameterDirection.Input) &&
                        (parameter.Value == null))
                    {
                        parameter.Value = DBNull.Value;
                    }
                    command.Parameters.Add(parameter);
                }
            }

            return command;
        }

        /// <summary>
        /// ִд洢̣Ӱ		
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <param name="rowsAffected">Ӱ</param>
        /// <returns></returns>
        public static int RunProcedure(string storedProcName, IDataParameter[] parameters, out int rowsAffected)
        {
            using (OleDbConnection connection = new OleDbConnection(connectionString))
            {
                int result;
                connection.Open();
                OleDbCommand command = BuildIntCommand(connection, storedProcName, parameters);
                rowsAffected = command.ExecuteNonQuery();
                result = (int)command.Parameters["ReturnValue"].Value;
                //Connection.Close();
                return result;
            }
        }

        /// <summary>
        ///  OleDbCommand ʵ(һֵ)	
        /// </summary>
        /// <param name="storedProcName">洢</param>
        /// <param name="parameters">洢̲</param>
        /// <returns>OleDbCommand ʵ</returns>
        private static OleDbCommand BuildIntCommand(OleDbConnection connection, string storedProcName, IDataParameter[] parameters)
        {
            OleDbCommand command = BuildQueryCommand(connection, storedProcName, parameters);
            command.Parameters.Add(new OleDbParameter("ReturnValue",OleDbType.Integer
               , 4, ParameterDirection.ReturnValue,
                false, 0, 0, string.Empty, DataRowVersion.Default, null));
            return command;
        }
        #endregion
    }

}
