﻿
var testEditor;
var _ispreview = true;

var c = $.cookie("ispreview");
if (c == 0) {
    _ispreview = false;
    $("#watch").prop("checked", false);
}
else {
    $("#watch").prop("checked", true);
}



function ispreview() {
    if (!$("#watch").prop("checked")) {
        $.cookie("ispreview", "0", { expires: 7 });
    }
    else {
        $.cookie("ispreview", "1", { expires: 7 });
    }
}


testEditor = editormd("test-editormd", {
    width: "100%",
    height: 450,
    placeholder: "",
    emoji: false,
    lineNumbers: true,
    autoFocus:false,
    watch: _ispreview,
    path: AppPath+"javascript/pandao-markdown/lib/",
    toolbarIcons: function () {
        return ["bold", "quote", "|", "h3", "h4", "h5", "h6", "list-ul", "list-ol", "|", "code", "code-block", "|", "link", "image", "|", "table"]
    },

    imageUpload: true,
    imageFormats: ["jpg", "jpeg", "gif", "png", "bmp", "webp"],
    imageUploadURL: "save_img.aspx",
    saveHTMLToTextarea: true


});


$("#watch").bind('click', function () {
    $.proxy(testEditor.toolbarHandlers.watch, testEditor)();
});





var uploader = WebUploader.create({
    auto: true,
    server: AppPath+'ajax/upload.aspx',
    pick: '#picker',
    accept: {
        extensions: 'gif,jpg,jpeg,png,pdf,doc,docx,xls,xlsx,ppt,pptx,zip,rar,mp4',
        mimeTypes: '.gif,.jpg,.jpeg,.png,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.zip,.rar,.mp4'
    }

});

uploader.on('uploadSuccess', function (file, res) {

    var ext = res.ext;
    var name = res.name;
    var path = res.path;
    var oldMd = testEditor.getMarkdown();
    var newMd = "";
    if (ext == ".jpg" || ext == ".jpeg" || ext == ".gif" || ext == ".png") {
        newMd = oldMd + "![图片](" + path + ")";
    }
    else {
        newMd = oldMd + "[" + name + "](" + path + ")";
    }
    testEditor.setMarkdown(newMd);

});