﻿$("#upload").change(function () {
    var files = document.getElementById("upload");
    var file = files.files[0];

    var reader = new FileReader();
    var img = new Image();

    var canvas = document.createElement('canvas');
    var context = canvas.getContext('2d');
    var maxWidth = 1200;
    var maxHeight = 900;


    var index = file.name.lastIndexOf(".");
    var ext = file.name.substr(index + 1).toLowerCase();


    if (ext != "jpg" && ext != "jpeg" && ext != "png") {
        alert("格式不正确");
        return;
    }





    if (file) {
        var theid = Math.random();
        reader.readAsDataURL(file);
        reader.onload = function (e) {
            //处理 android 4.1 兼容问题
            var base64 = reader.result.split(',')[1];
            var dataUrl = 'data:image/png;base64,' + base64;

            var placeholder = document.createElement('div');
            placeholder.setAttribute('id', 'pre_' + theid);
            placeholder.setAttribute('class', 'previews');
            placeholder.style.backgroundImage = 'url(' + dataUrl + ')';

            var close = document.createElement('div');
            close.setAttribute('class', 'cls');
            close.setAttribute('id', "cls_" + theid);
            close.innerHTML = "X";
            close.setAttribute('onclick', "_del('" + theid + "')");

            var hidden = document.createElement('input');
            hidden.setAttribute('type', 'hidden');
            hidden.setAttribute('class', 'imgItem');
            hidden.setAttribute('id', "hdn_" + theid);

            placeholder.appendChild(close);
            placeholder.appendChild(hidden);

            document.getElementById("previews").appendChild(placeholder);
            img.src = dataUrl; // e.target.result;
        }




        img.onload = function () {
            // 图片原始尺寸 
            var originWidth = this.width;
            var originHeight = this.height;
            // 最大尺寸限制


            // 目标尺寸
            var targetWidth = originWidth;
            var targetHeight = originHeight;

            // 图片尺寸超过400x400的限制
            if (originWidth > maxWidth || originHeight > maxHeight) {
                if (originWidth / originHeight > maxWidth / maxHeight) {
                    // 更宽，按照宽度限定尺寸
                    targetWidth = maxWidth;
                    targetHeight = Math.round(maxWidth * (originHeight / originWidth));
                } else {
                    targetHeight = maxHeight;
                    targetWidth = Math.round(maxHeight * (originWidth / originHeight));
                }
            }

            // canvas对图片进行缩放
            canvas.width = targetWidth;
            canvas.height = targetHeight;
            // 清除画布
            context.clearRect(0, 0, targetWidth, targetHeight);
            // 图片压缩
            context.drawImage(img, 0, 0, targetWidth, targetHeight);

            // canvas转为blob并上传
            var base64 = canvas.toDataURL('image/jpeg', 0.8);



            $.ajax({
                url: "ajax/save.aspx",
                data: { base64: base64 },
                type: "post",
                cache: false,
                async: false,
                success: function (r) {
                    document.getElementById("hdn_" + theid).value += " ![图片](" + r + ") ";
                }
            });

        }
    }



});



function _del(rid) {
    var item = document.getElementById("pre_" + rid);
    document.getElementById("previews").removeChild(item);

}