/*系统*/
var System = function() {  }

/*值部分*/
System.Var = function() {  }
System.Var.AutoTagsSelect = null;

/*全选*/
System.SelectAll = function(form)
{
	for (var i = 0; i < form.elements.length; i++)
	{
		var e = form.elements[i];
		if (e.checked == "") { e.checked = "checked"; } else { e.checked = ""; }
    }
}

/*编码部分*/
System.Encode = function() {  }
System.Encode.URI = function(value)
{
	return encodeURIComponent(value);
}

/*窗口操作部分*/
System.Window = function() {  }
System.Window.Link = function(url)
{
	self.location.href = url;
}

/*提示框部分*/
System.MsgBox = function() {  }
System.MsgBox.Show = function(txt)
{
	$.prompt(txt);
}
System.MsgBox.Set = function(txt)
{
	$.ImpromptuClose();
	$.prompt(txt);
}
System.MsgBox.Remove = function()
{
	$.ImpromptuClose();
}

/*取值部分*/
System.Get = function() {  }
System.Get.EditorXHTML = function(editorID)
{
	var oEditor = FCKeditorAPI.GetInstance(editorID); 
    return(oEditor.GetXHTML(true));
}
System.Get.CheckBoxValue = function(name)
{
	var sName = "";
	var sNames = document.getElementsByName(name);
	for (var i = 0; i < sNames.length; i++)
	{
		if (sNames[i].checked) { sName += System.Encode.URI(sNames[i].value) + ","; }
	}
	if (sName != "") { sName = sName.substring(0, sName.lastIndexOf(",")); }
	if (sName == ",") { sName = ""; }
	return sName;
}
System.Get.ListValue = function(name)
{
	var sName = "";
	var sNames = document.getElementsByName(name);
	for (var i = 0; i < sNames.length; i++)
	{
		sName += System.Encode.URI(sNames[i].value) + ",";
	}
	if (sName != "") { sName = sName.substring(0, sName.lastIndexOf(",")); }
	if (sName == ",") { sName = ""; }
	return sName;
}
System.Get.RadioValue = function(radioName)
{
	var value = "";
	var radioObj = document.getElementsByName(radioName);
	if (radioObj) { for (var i = 0; i < radioObj.length; i++) { if (radioObj[i].checked) { value = radioObj[i].value; break; } } }
	return value;
}
System.Get.XML = function(xmlObj, tagName)
{
	var sR = "";
	try { sR = $(xmlObj).find(tagName).text(); }
	catch (e) {  }
	return sR;
}
System.Get.ImageHTML = function(url)
{
	return "<img src=\"" + url + "\" />";
}
System.Get.FileHTML = function(url, caption)
{
	return "<a href=\"" + url + "\">" + caption + "</a>";
}
System.Get.Page = function(cls, mode)
{
	System.MsgBox.Show(Language.Load.Page);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=" + cls + "&Mode=" + mode,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*设置部分*/
System.Set = function() {  }
System.Set.EditorInsert = function(objid, content)
{
	var oEditor = FCKeditorAPI.GetInstance(objid);
	if ( oEditor.EditMode == FCK_EDITMODE_WYSIWYG )
	{
		oEditor.InsertHtml(content);
	}
}
System.Set.Value = function(obj, value)
{
	obj.value = value;
}

/*登录注销*/
System.Login = function(uid, pwd, vc)
{
	System.MsgBox.Show(Language.User.IsLogin);
	var sPostData = "sysUserUID=" + System.Encode.URI(uid);
	sPostData += "&sysUserPWD=" + System.Encode.URI(pwd);
	sPostData += "&sysVerifyCode=" + System.Encode.URI(vc);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Entry&Mode=Login&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			setTimeout(function(){document.location.reload();}, 2000);
		}
	});
}
System.Exit = function()
{
	if (confirm(Language.Ask.AreYouExit))
	{
		System.MsgBox.Show(Language.User.Exit);
		$.ajax({
			type : "get",
			url : "Handle.aspx?Class=Entry&Mode=Exit",
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
				setTimeout(function(){document.location.reload();}, 2000);
			}
		});
	}
}

/*缓存部分*/
System.Cache = function() {  }
System.Cache.Clear = function()
{
	System.MsgBox.Show(Language.Cache.Clear);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Setting&Mode=Database&Job=CacheClear",
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*配置部分*/
System.Setting = function() {  }
System.Setting.BasicSave = function(cap, url, icp, intro, keys, affiche, uploadext)
{
	System.MsgBox.Show(Language.Save.Setting);
	var sPostData = "sysSettingCaption=" + System.Encode.URI(cap);
	sPostData += "&sysSettingURL=" + System.Encode.URI(url);
	sPostData += "&sysSettingICP=" + System.Encode.URI(icp);
	sPostData += "&sysSettingIntro=" + System.Encode.URI(intro);
	sPostData += "&sysSettingKeywords=" + System.Encode.URI(keys);
	sPostData += "&sysSettingAffiche=" + System.Encode.URI(affiche);
	sPostData += "&sysSettingUploadExt=" + System.Encode.URI(uploadext);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Basic&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Setting.ParameterSave = function(artnum, cmtnum, appartnum, apphotnum, apprandomnum, appcmtnum, apptagnum, wms, bokeccid, avcmt, avtb, switchcmt, switchtb)
{
	System.MsgBox.Show(Language.Save.Setting);
	var sPostData = "sysSettingArticleNum=" + artnum;
	sPostData += "&sysSettingCommentNum=" + cmtnum;
	sPostData += "&sysSettingAppendArticleNum=" + appartnum;
	sPostData += "&sysSettingAppendHotArticleNum=" + apphotnum;
	sPostData += "&sysSettingAppendRandomArticleNum=" + apprandomnum;
	sPostData += "&sysSettingAppendCommentNum=" + appcmtnum;
	sPostData += "&sysSettingAppendTagNum=" + apptagnum;
	sPostData += "&sysSettingWMSeat=" + wms;
	sPostData += "&sysSettingBokeCCID=" + bokeccid;
	sPostData += "&sysSettingAutoVerifyComment=" + avcmt;
	sPostData += "&sysSettingAutoVerifyTrackback=" + avtb;
	sPostData += "&sysSettingSwitchComment=" + switchcmt;
	sPostData += "&sysSettingSwitchTrackback=" + switchtb;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Parameter&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Setting.PlusParameterSave = function(photoswitch, photonum, boardswitch, boardnum, photoverify, boardverify)
{
	System.MsgBox.Show(Language.Save.Setting);
	var sPostData = "sysSettingPlusPhotoSwitch=" + photoswitch;
	sPostData += "&sysSettingPlusPhotoNum=" + photonum;
	sPostData += "&sysSettingPlusBoardSwitch=" + boardswitch;
	sPostData += "&sysSettingPlusBoardNum=" + boardnum;
	sPostData += "&sysSettingPlusPhotoAutoVerify=" + photoverify;
	sPostData += "&sysSettingPlusBoardAutoVerify=" + boardverify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Plus&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Setting.MailSave = function(from, host, port, uid, pwd)
{
	System.MsgBox.Show(Language.Save.MailService);
	var sPostData = "sysSettingMailFrom=" + System.Encode.URI(from);
	sPostData += "&sysSettingMailHost=" + System.Encode.URI(host);
	sPostData += "&sysSettingMailPort=" + port;
	sPostData += "&sysSettingMailUID=" + System.Encode.URI(uid);
	sPostData += "&sysSettingMailPWD=" + System.Encode.URI(pwd);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Mail&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Setting.SpamSave = function(filter)
{
	System.MsgBox.Show(Language.Save.Setting);
	var sPostData = "sysSettingFilter=" + System.Encode.URI(filter);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Spam&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*数据库部分*/
System.Database = function() {  }
System.Database.Count = function()
{
	System.MsgBox.Show(Language.Save.Count);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Setting&Mode=Database&Job=Count",
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Database.Backup = function()
{
	System.MsgBox.Show(Language.Save.Database);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Setting&Mode=Database&Job=Backup",
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Database.SQLExecute = function(sql)
{
	System.MsgBox.Show(Language.Save.SQL);
	var sPostData = "sysDatabaseSQL=" + System.Encode.URI(sql);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Setting&Mode=Database&Job=SQL",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*文章部分*/
System.Article = function() {  }
System.Article.Post = function(articleid, catid, title, tags, label, content, publish, verify, put, password, tblist)
{
	System.MsgBox.Show(Language.Save.Article);
	var sPostData = "sysArticleCategoryID=" + System.Encode.URI(catid);
	sPostData += "&sysArticleTitle=" + System.Encode.URI(title);
	sPostData += "&sysArticleTags=" + System.Encode.URI(tags);
	sPostData += "&sysArticleLabel=" + System.Encode.URI(label);
	sPostData += "&sysArticleContent=" + System.Encode.URI(content);
	sPostData += "&sysArticlePublish=" + System.Encode.URI(publish);
	sPostData += "&sysArticleVerify=" + verify;
	sPostData += "&sysArticlePut=" + put;
	sPostData += "&sysArticlePassword=" + System.Encode.URI(password);
	sPostData += "&sysArticleTrackbackList=" + System.Encode.URI(tblist);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Article&Mode=Post&ID=" + articleid + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Article.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Article);
		var sPostData = "sysArticleItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Article&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Article.Verify = function(idlist)
{
	var iState = 0;
	if (confirm(Language.Ask.AreYouVerify)) { iState = 1; }
	System.MsgBox.Show(Language.Verify.Article);
	var sPostData = "sysArticleItemCheckBox=" + System.Encode.URI(idlist);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Article&Mode=List&Job=Verify&State=" + iState,
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Article.Edit = function(articleid)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Article&Mode=Post&ID=" + articleid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Article.SelectPage = function(cateid, key, page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Article&Mode=List&CategoryID=" + cateid + "&Key=" + System.Encode.URI(key) + "&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
/*标签提示*/
System.Article.TagsSelectStart = function()
{
	System.Var.AutoTagsSelect = setInterval("System.Article.TagsSelectExecute()", 1000);	//1000ms=1s
}
System.Article.TagsSelectExecute = function()
{
	var arrTag = document.getElementById("sysArticleTags").value.split(",");
	var thisTag = arrTag[arrTag.length - 1];
	if (thisTag == "")
	{
		document.getElementById("sysArticleTagsCue").innerHTML = "wait...";
	}
	else
	{
		var sPostData = "sysTag=" + System.Encode.URI(thisTag);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Article&Mode=SelectTags",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { alert(xmlMessage); }
				if (xmlContent.length > 0) { $("#sysArticleTagsCue").html(xmlContent); } else { $("#sysArticleTagsCue").html(""); }
			}
		});
	}
}
System.Article.TagsSelectEnd = function()
{
	if (System.Var.AutoTagsSelect != null)
	{
		clearInterval(System.Var.AutoTagsSelect);
	}
}
System.Article.TagsSelectInsert = function(tagName)
{
	var tagList = $("#sysArticleTags")[0].value;
	var tags = tagList.split(",");
	var sTags = "";
	for (var i = 0; i < (tags.length - 1); i++)
	{
		sTags += tags[i] + ",";
	}
	$("#sysArticleTags")[0].value = sTags + tagName;
}

/*相册部分*/
System.Album = function() {  }
System.Album.Edit = function(albumid)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=Album&ID=" + albumid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Album.Lock = function(albumid, state)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=List&Job=AlbumLock&ID=" + albumid + "&LockState=" + state,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Album.Post = function(id, name, intro, sorting, verify)
{
	System.MsgBox.Show(Language.Save.Album);
	var sPostData = "sysAlbumName=" + System.Encode.URI(name);
	sPostData += "&sysAlbumIntro=" + System.Encode.URI(intro);
	sPostData += "&sysAlbumSorting=" + sorting;
	sPostData += "&sysAlbumVerify=" + verify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Photo&Mode=Album&ID=" + id + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Album.Delete = function(id)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Page);
		$.ajax({
			type : "get",
			url : "Handle.aspx?Class=Photo&Mode=List&Job=AlbumDelete&ID=" + id,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Album.This = function(id)
{
	System.MsgBox.Show(Language.Load.Page);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=List&AlbumID=" + id,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Photo = function() {  }
System.Photo.Edit = function(id)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=Edit&ID=" + id,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Photo.Post = function(id, name, intro, verify)
{
	System.MsgBox.Show(Language.Save.Photo);
	var sPostData = "sysPhotoName=" + System.Encode.URI(name);
	sPostData += "&sysPhotoIntro=" + System.Encode.URI(intro);
	sPostData += "&sysPhotoVerify=" + verify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Photo&Mode=Edit&ID=" + id + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Photo.ToCover = function(id, albumid)
{
	System.MsgBox.Show(Language.Save.Cover);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=List&AlbumID=" + albumid + "&ID=" + id + "&Job=PhotoToCover",
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Photo.Delete = function(albumid, idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Page);
		var sPostData = "sysPhotoItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Photo&Mode=List&AlbumID=" + albumid + "&Job=PhotoDelete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Photo.SelectPage = function(albumid, page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Photo&Mode=List&AlbumID=" + albumid + "&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*页面部分*/
System.Page = function() {  }
System.Page.Post = function(pageid, title, label, content, sorting, isnav, verify)
{
	System.MsgBox.Show(Language.Save.Page);
	var sPostData = "sysPageTitle=" + System.Encode.URI(title);
	sPostData += "&sysPageLabel=" + System.Encode.URI(label);
	sPostData += "&sysPageContent=" + System.Encode.URI(content);
	sPostData += "&sysPageSorting=" + sorting;
	sPostData += "&sysPageIsNav=" + isnav;
	sPostData += "&sysPageVerify=" + verify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Page&Mode=Post&ID=" + pageid + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Page.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Page);
		var sPostData = "sysPageItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Page&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Page.Edit = function(pageid)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Page&Mode=Post&ID=" + pageid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Page.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Page&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*评论部分*/
System.Comment = function() {  }
System.Comment.ReplyPost = function(commentid, reply, verify, tomail)
{
	System.MsgBox.Show(Language.Save.Reply);
	var sPostData = "sysCommentReply=" + System.Encode.URI(reply);
	sPostData += "&sysCommentVerify=" + verify;
	sPostData += "&sysCommentToMail=" + tomail;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Comment&Mode=Reply&ID=" + commentid + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Comment.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Comment);
		var sPostData = "sysCommentItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Comment&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Comment.Reply = function(commentid)
{
	System.MsgBox.Show(Language.Load.Reply);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Comment&Mode=Reply&ID=" + commentid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Comment.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Comment&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*论板部分*/
System.Board = function() {  }
System.Board.ReplyPost = function(commentid, reply, verify, tomail)
{
	System.MsgBox.Show(Language.Save.Reply);
	var sPostData = "sysBoardReply=" + System.Encode.URI(reply);
	sPostData += "&sysBoardVerify=" + verify;
	sPostData += "&sysBoardToMail=" + tomail;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Board&Mode=Reply&ID=" + commentid + "&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Board.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Board);
		var sPostData = "sysBoardItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Board&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Board.Reply = function(commentid)
{
	System.MsgBox.Show(Language.Load.Reply);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Board&Mode=Reply&ID=" + commentid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Board.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Board&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*分类部分*/
System.Category = function() {  }
System.Category.Post = function(idlist, names, labels, sortings, name, label, sorting)
{
	System.MsgBox.Show(Language.Save.Category);
	var sPostData = "sysCategoryItemCheckBox=" + idlist;
	sPostData += "&sysCategoryName=" + names;
	sPostData += "&sysCategoryLabel=" + labels;
	sPostData += "&sysCategorySorting=" + sortings;
	sPostData += "&sysCategoryName_Add=" + System.Encode.URI(name);
	sPostData += "&sysCategoryLabel_Add=" + System.Encode.URI(label);
	sPostData += "&sysCategorySorting_Add=" + sorting;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Category&Mode=Post&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Category.LotMove = function(sourceid, toid)
{
	System.MsgBox.Show(Language.Save.Move);
	var sPostData = "sysCategoryID_Source=" + sourceid;
	sPostData += "&sysCategoryID_To=" + toid;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Category&Mode=LotMove&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Category.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Category);
		var sPostData = "sysCategoryItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Category&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}

/*标签部分*/
System.Tag = function() {  }
System.Tag.Post = function(keys, names, addname)
{
	System.MsgBox.Show(Language.Save.Tags);
	var sPostData = "sysTagItemCheckBox=" + keys;
	sPostData += "&sysTagName=" + names;
	sPostData += "&sysTagName_Add=" + System.Encode.URI(addname);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Tag&Mode=Post&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Tag.Delete = function(keys)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Tags);
		var sPostData = "sysTagItemCheckBox=" + keys;
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Tag&Mode=Post&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Tag.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Tag&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*用户部分*/
System.User = function() {  }
System.User.Post = function(id, uid, pwd, name, verify)
{
	System.MsgBox.Show(Language.Save.User);
	var sPostData = "sysUserUID=" + System.Encode.URI(uid);
	sPostData += "&sysUserPWD=" + System.Encode.URI(pwd);
	sPostData += "&sysUserName=" + System.Encode.URI(name);
	sPostData += "&sysUserVerify=" + verify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=User&Mode=Post&Job=Post&ID=" + id,
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.User.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.User);
		var sPostData = "sysUserItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=User&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.User.Edit = function(userid)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=User&Mode=Post&ID=" + userid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.User.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=User&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*链接部分*/
System.Fellow = function() {  }
System.Fellow.Post = function(id, name, url, explain, style, sorting, isindex, verify)
{
	System.MsgBox.Show(Language.Save.Fellow);
	var sPostData = "sysFellowName=" + System.Encode.URI(name);
	sPostData += "&sysFellowURL=" + System.Encode.URI(url);
	sPostData += "&sysFellowExplain=" + System.Encode.URI(explain);
	sPostData += "&sysFellowStyle=" + System.Encode.URI(style);
	sPostData += "&sysFellowSorting=" + sorting;
	sPostData += "&sysFellowIsIndex=" + isindex;
	sPostData += "&sysFellowVerify=" + verify;
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Fellow&Mode=Post&Job=Post&ID=" + id,
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Fellow.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Fellow);
		var sPostData = "sysFellowItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Fellow&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}
System.Fellow.Edit = function(linkid)
{
	System.MsgBox.Show(Language.Load.Edit);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Fellow&Mode=Post&ID=" + linkid,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Fellow.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Fellow&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*附件部分*/
System.Attach = function() {  }
System.Attach.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Attach&Mode=List&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Attach.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Attach);
		var sPostData = "sysAttachItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Attach&Mode=List&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}

/*引用通告部分*/
System.Trackback = function() {  }
System.Trackback.SelectPage = function(page)
{
	if (page == 0) { page = 1; }
	System.MsgBox.Show(Language.Load.Pages);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Global&Mode=Trackback&Page=" + page,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Trackback.Delete = function(idlist)
{
	if (confirm(Language.Ask.AreYouDelete))
	{
		System.MsgBox.Show(Language.Delete.Trackback);
		var sPostData = "sysTBItemCheckBox=" + System.Encode.URI(idlist);
		$.ajax({
			type : "post",
			url : "Handle.aspx?Class=Global&Mode=Trackback&Job=Delete",
			data : sPostData,
			success : function(rexm)
			{
				var xmlMessage = System.Get.XML(rexm, "Message");
				var xmlContent = System.Get.XML(rexm, "Content");
				if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
				if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
			}
		});
	}
}

/*主题部分*/
System.Theme = function() {  }
System.Theme.Save = function(dir)
{
	System.MsgBox.Show(Language.Save.Setting);
	var sPostData = "sysSettingTheme=" + System.Encode.URI(dir);
	$.ajax({
		type : "post",
		url : "Handle.aspx?Class=Theme&Mode=Set&Job=Post",
		data : sPostData,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}
System.Theme.Edit = function(file)
{
	System.MsgBox.Show(Language.Load.Page);
	$.ajax({
		type : "get",
		url : "Handle.aspx?Class=Theme&Mode=Edit&File=" + file,
		success : function(rexm)
		{
			var xmlMessage = System.Get.XML(rexm, "Message");
			var xmlContent = System.Get.XML(rexm, "Content");
			if (xmlMessage.length > 0) { System.MsgBox.Set(xmlMessage); } else { System.MsgBox.Remove(); }
			if (xmlContent.length > 0) { $("#sysDOM").html(xmlContent); }
		}
	});
}

/*绑定载入过程*/
$(document).ready(function()
{
	$("#sysMenu li").mouseover(function()
	{
		$(this).addClass("sysMenuIE_hover");
		$("select").each(function()
		{
			this.style.visibility = "hidden";
		});
	}).mouseout(function()
	{
		$(this).removeClass("sysMenuIE_hover");
		$("select").each(function()
		{
			this.style.visibility = "visible";
		});
	});
	$("a[rel='external']").click(function()
	{
		window.open(this.href, "_blank");
		return false;
	});
	$("input[type=submit]").addClass("sysButton");
	$("input[type=button]").addClass("sysButton");
});