﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
  version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:common="http://www.foxcup.com/common"
  >
  <xsl:output
    method="html"
    version="1.0"
    encoding="utf-8"
    omit-xml-declaration="no"
    media-type="text/html"
    indent="yes"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    />
  <xsl:template match="Roclog.UI">
    <html>
      <head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <title>后台管理</title>
        <script type="text/javascript" src="/Common/Language/zh-cn/Elements.js" xml:space="preserve"> </script>
        <script type="text/javascript" src="/Common/Manage/Skin/jQuery.js" xml:space="preserve"> </script>
        <script type="text/javascript" src="/Common/Manage/Skin/jquery-impromptu.js" xml:space="preserve"> </script>
        <script type="text/javascript" src="/Common/Manage/Skin/Common.js" xml:space="preserve"> </script>
        <link href="/Common/Manage/Skin/Style.css" rel="stylesheet" type="text/css"/>
        <link href="/Common/Manage/Skin/Message.css" rel="stylesheet" type="text/css"/>
      </head>
      <body>
        <div class="Page">

	  <!--头部-->
          <div class="Top">
            <xsl:if test="common:CookieGet('Manager_Name')!=''">尊敬的: <xsl:value-of select="common:CookieGet('Manager_Name')"/> (<a href="javascript:System.User.Edit({common:CookieGet('Manager_ID')});"><xsl:value-of select="common:CookieGet('Manager_UID')"/></a>) | 最后登录: <a title="IP: {common:CookieGet('Manager_LastIP')}"><xsl:value-of select="common:CookieGet('Manager_LastEnter')"/></a></xsl:if>
            <xsl:if test="common:CookieGet('Manager_Name')=''">请您先进行系统登录才可继续操作！</xsl:if>
          </div>

	  <!--导航部分-->
          <div class="Nav">
            <ul id="sysMenu">
              <xsl:if test="common:CookieGet('Manager_Name')!=''">
                <xsl:for-each select="This.Menu/Item">
                  <li class="sysMenuTitle"><a href="{@Link}"><xsl:value-of select="@Caption"/></a>
                    <ul class="sysMenuDrop" xml:space="preserve">
                      <xsl:for-each select="Vassal">
                        <li><a href="{@Link}"><xsl:value-of select="@Caption"/></a></li>
                      </xsl:for-each>
                    </ul>
                  </li>
                </xsl:for-each>
              </xsl:if>
              <xsl:if test="common:CookieGet('Manager_Name')=''">
                <li class="sysMenuTitle"><a href="#">欢迎登录</a>
                  <ul class="sysMenuDrop">
                    <li><a href="../使用文档/使用说明.txt" rel="external">使用说明</a></li>
                    <li><a href="../使用文档/缓存表.txt" rel="external">缓存表</a></li>
                    <li><a href="../使用文档/更新日志.txt" rel="external">版本更新</a></li>
                  </ul>
                </li>
              </xsl:if>
            </ul>
          </div>

	  <!--主内容显示部分-->
          <div id="sysDOM" class="Content">
            <xsl:value-of select="This.Content" disable-output-escaping="yes"/>
          </div>

	  <!--底部信息-->
          <div class="Foot">
            <xsl:choose>
              <xsl:when test="Global.Config/Authorization != ''">Authorization number: <span class="sysBold"><xsl:value-of select="Global.Config/Authorization"/></span></xsl:when>
              <xsl:when test="Global.Config/Authorization = ''"><span class="sysRed">No authorization</span></xsl:when>
            </xsl:choose>
            <br />
            <xsl:value-of select="Global.Config/Powered" disable-output-escaping="yes"/>
          </div>

        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>