﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:string="http://www.foxcup.com/string"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent">
										<!--日志列表-->
										<div class="logs" xml:space="preserve">
										<xsl:for-each select="This.Articles/Item">
											<div class="item">
												<div class="title">
													<h1>
														<span xml:space="preserve">
															<xsl:value-of select="Article.Publish"/>
														</span>
														<a title="{Article.Title}" href="{$Config/AppPath}Article/{Article.Label}.aspx" xml:space="preserve">
															<xsl:value-of select="Article.Title"/>
														</a>
													</h1>
												</div>
												<div class="other">
													分类:(<a href="{$Config/AppPath}Category/{Category.Label}.aspx" title="{Category.Name}"><xsl:value-of select="Category.Name"/></a>) | 评论:(<xsl:value-of select="Article.CommentCount"/>) | 浏览:(<xsl:value-of select="Article.Reader"/>) | 标签: <xsl:value-of select="string:TagsSplit(Article.Tags, ',', ' ')" disable-output-escaping="yes"/>
												</div>
												<div class="content" xml:space="preserve">
													<xsl:if test="Article.Password!=''">
														<p style="color:red;">加密内容</p>
													</xsl:if>
													<xsl:if test="Article.Password=''">
														<xsl:value-of select="Article.Explain" disable-output-escaping="yes"/>
													</xsl:if>
												</div>
												<xsl:if test="string:Length(Article.Explain)!=string:Length(Article.Content)">
													<div class="more"><a href="{$Config/AppPath}Article/{Article.Label}.aspx">阅读更多...</a></div>
												</xsl:if>
											</div>
										</xsl:for-each>
										</div>

										<div class="pageBar">
											<span class="current">
												<xsl:value-of select="This.Articles/Pages/Info/This"/>/<xsl:value-of select="This.Articles/Pages/Info/Pages"/>
											</span>
											<xsl:for-each select="This.Articles/Pages/Page">
												<xsl:if test="@Link!=''">
													<a href="{@Link}">
														<xsl:value-of select="@Text"/>
													</a>
												</xsl:if>
												<xsl:if test="@Link=''">
													<span class="current">
														<xsl:value-of select="@Text"/>
													</span>
												</xsl:if>
											</xsl:for-each>
											<div style="clear:left" xml:space="preserve"> </div>
										</div>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>