﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:string="http://www.foxcup.com/string"
	xmlns:common="http://www.foxcup.com/common"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent">
										<!--日志列表-->
										<div class="logs">
											<xsl:for-each select="This.Article">
											<div class="item">
												<div class="title">
													<h1>
														<span xml:space="preserve">
															<xsl:value-of select="Article.Publish"/>
														</span>
														<a title="{Article.Title}" href="{$Config/AppPath}Article/{Article.Label}.aspx">
															<xsl:value-of select="Article.Title"/>
														</a>
													</h1>
												</div>
												<div class="other">
													分类:(<a href="{$Config/AppPath}Category/{Category.Label}.aspx" title="{Category.Name}"><xsl:value-of select="Category.Name"/></a>) | 评论:(<xsl:value-of select="Article.CommentCount"/>) | 浏览:(<xsl:value-of select="Article.Reader"/>) | 标签:  <xsl:value-of select="string:TagsSplit(Article.Tags, ',', ' ')" disable-output-escaping="yes"/>
												</div>
												<div class="content" id="contentDom" xml:space="preserve">
													<xsl:if test="Article.Password!=''">
														<span style="color:red;">加密内容</span><br/>
														密码：<input type="text" id="ArticlePasswordInput_{Article.ID}"/> <input type="button" value="验证" onclick="javascript:System.Article.PWDCheck({Article.ID}, document.getElementById('ArticlePasswordInput_{Article.ID}').value, this);"/>
													</xsl:if>
													<xsl:if test="Article.Password=''">
														<xsl:value-of select="Article.Content" disable-output-escaping="yes"/>
													</xsl:if>
												</div>
												<div class="more">
													上一篇：<xsl:value-of select="common:GetPrevArticle(Article.ID)" disable-output-escaping="yes"/><br/>
													下一篇：<xsl:value-of select="common:GetNextArticle(Article.ID)" disable-output-escaping="yes"/><br/>
													此文章已被顶 [<a href="#" onclick="javascript:System.Article.Voting({Article.ID}, this);return false;"><span id="articlevotenum"><xsl:value-of select="Article.Vote"/></span></a>] 次<br/>
													<a href="{$Config/AppPath}Feed/Comment/{Article.Label}.aspx" onclick="javascript:window.open(this.href, '_blank');return false;">订阅此篇文章的最新评论</a> | <a href="{$Config/AppPath}Trackback/{Article.Label}.aspx" onclick="javascript:window.open(this.href, '_blank');return false;">获取引用通告地址</a>
												</div>
											</div>
											</xsl:for-each>
										</div>

										<div class="comments">
											<div><a name="commentlist">以下是别人对此篇文章的见解：</a></div>
											<div id="getcomment" xml:space="preserve">
												<xsl:call-template name="CommentList">
													<xsl:with-param name="Comments" select="This.Comments/Item"/>
													<xsl:with-param name="Pages" select="This.Comments/Pages"/>
												</xsl:call-template>
											</div>
											<div class="commentpost">
												<table width="100%" border="0" cellspacing="0" cellpadding="0">
												<tr>
												<th>称　呼：</th><td><input id="post_username" size="40" value="{common:CookieGet('Usual_GuestUserName')}"/> * (您的姓名)</td>
												</tr>
												<tr>
												<th>邮　件：</th><td><input id="post_usermail" size="40" value="{common:CookieGet('Usual_GuestUserMail')}"/> * (邮箱地址)</td>
												</tr>
												<tr>
												<th>网　站：</th><td><input id="post_userurl" size="40" value="{common:CookieGet('Usual_GuestUserURL')}"/></td>
												</tr>
												<tr>
												<th>内　容：</th><td><xsl:text disable-output-escaping="yes"><![CDATA[<textarea id="post_content" cols="80" rows="10"></textarea>]]></xsl:text></td>
												</tr>
												<tr>
												<th>验证码：</th><td><xsl:value-of select="common:GetVerifyCode('post_vc', '', '')" disable-output-escaping="yes"/></td>
												</tr>
												<tr>
												<th>　</th><td><input type="button" value="发表评论(S)" onclick="javascript:System.Comment.Post({This.Article/Article.ID}, document.getElementById('post_username').value, document.getElementById('post_usermail').value, document.getElementById('post_userurl').value, document.getElementById('post_content').value, document.getElementById('post_vc').value, this);"/> <input type="button" value="重置(R)" onclick="javascript:$('.commentpost textarea').val('');"/></td>
												</tr>
												</table>
											</div>
										</div>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>