﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:common="http://www.foxcup.com/common"
	xmlns:integer="http://www.foxcup.com/integer"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent" xml:space="preserve">
										<xsl:if test="Global.Setting/PlusBoardSwitch='0'">
											论板功能还没有开放，暂时不可使用。
										</xsl:if>
										<xsl:if test="Global.Setting/PlusBoardSwitch!='0'">
											<!--列表-->
											<div><a name="boardlist">您可以在这里留下您的意见：</a></div>
											<div class="boards" id="getboards">
												<xsl:call-template name="BoardList">
													<xsl:with-param name="Boards" select="This.Boards/Item"/>
													<xsl:with-param name="Pages" select="This.Boards/Pages"/>
												</xsl:call-template>
											</div>
										
											<div class="boardpost">
												<table width="100%" border="0" cellspacing="0" cellpadding="0">
												<tr>
												<th>称　呼：</th><td><input id="post_username" size="40" value="{common:CookieGet('Usual_GuestUserName')}"/> * (您的姓名)</td>
												</tr>
												<tr>
												<th>邮　件：</th><td><input id="post_usermail" size="40" value="{common:CookieGet('Usual_GuestUserMail')}"/> * (邮箱地址)</td>
												</tr>
												<tr>
												<th>网　站：</th><td><input id="post_userurl" size="40" value="{common:CookieGet('Usual_GuestUserURL')}"/></td>
												</tr>
												<tr>
												<th>内　容：</th><td><xsl:text disable-output-escaping="yes"><![CDATA[<textarea id="post_content" cols="80" rows="10"></textarea>]]></xsl:text></td>
												</tr>
												<tr>
												<th>验证码：</th><td><xsl:value-of select="common:GetVerifyCode('post_vc', '', '')" disable-output-escaping="yes"/></td>
												</tr>
												<tr>
												<th>　</th><td><input type="button" value="发言(S)" onclick="javascript:System.Board.Post(document.getElementById('post_username').value, document.getElementById('post_usermail').value, document.getElementById('post_userurl').value, document.getElementById('post_content').value, document.getElementById('post_vc').value, this);"/> <input type="button" value="重置(R)" onclick="javascript:$('.boardpost textarea').val('');"/></td>
												</tr>
												</table>
											</div>
										</xsl:if>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>