﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent">
										<!--列表-->
										<div class="links" xml:space="preserve">
											<xsl:for-each select="This.Fellows/Item">
											<div class="item">
												<a href="{Fellow.URL}" rel="external"><xsl:value-of select="Fellow.Name"/></a> (<xsl:value-of select="Fellow.Explain"/>)
											</div>
											</xsl:for-each>
										</div>

										<div class="linkpost">
											网站名称 (您的网站名字或标题)：<br/>
											<input id="post_flwname" size="40"/><br/>
											地　　址 (URL国际访问地址)：<br/>
											<input id="post_flwurl" size="40"/><br/>
											简单阐述：<br/>
											<input id="post_flwexplain" size="60"/><br/>
											<input type="button" value="申请链接" onclick="javascript:System.Fellow.Add(document.getElementById('post_flwname').value, document.getElementById('post_flwurl').value, document.getElementById('post_flwexplain').value, this);"/>
										</div>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>