﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:string="http://www.foxcup.com/string"
	xmlns:url="http://www.foxcup.com/url"
	xmlns:common="http://www.foxcup.com/common"
	>
	<!--声明-->
	<xsl:template name="Head">
		<xsl:param name="Title"/>
		<xsl:param name="Config"/>
		<xsl:param name="Setting"/>
		<head>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<script type="text/javascript" src="{$Config/AppPath}Theme/{$Setting/Theme}/Script/jQuery.js" xml:space="preserve"> </script>
			<script type="text/javascript" src="{$Config/AppPath}Theme/{$Setting/Theme}/Script/thickbox-compressed.js" xml:space="preserve"> </script>
			<script type="text/javascript" src="{$Config/AppPath}Theme/{$Setting/Theme}/Script/jquery.tooltip.pack.js" xml:space="preserve"> </script>
			<script type="text/javascript" src="{$Config/AppPath}Theme/{$Setting/Theme}/Script/AJAX.js" xml:space="preserve"> </script>
			<script type="text/javascript" src="{$Config/AppPath}Theme/{$Setting/Theme}/Script/Common.js" xml:space="preserve"> </script>
			<link rel="stylesheet" type="text/css" href="{$Config/AppPath}Theme/{$Setting/Theme}/Style.css"/>
			<link rel="stylesheet" type="text/css" href="{$Config/AppPath}Theme/{$Setting/Theme}/thickbox.css"/>
			<title xml:space="preserve"><xsl:if test="$Title!=''"><xsl:value-of select="$Title"/> - </xsl:if><xsl:value-of select="$Setting/Caption"/><xsl:if test="$Title=''"> - <xsl:value-of select="$Setting/Intro"/></xsl:if></title>
		</head>
	</xsl:template>

	<!--头部-->
	<xsl:template name="Top">
		<xsl:param name="Config"/>
		<xsl:param name="Setting"/>
		<xsl:param name="Pages"/>
		<div class="headBox">
			<div class="headTop" xml:space="preserve"> </div>
			<div class="headContent" xml:space="preserve">
				<xsl:value-of select="$Setting/Caption"/>
			</div>
			<div class="headFoot">
				<xsl:value-of select="$Setting/Intro"/>
			</div>
		</div>

		<div class="menuBox">
		<div class="menuTop" xml:space="preserve"> </div>
		<div class="menuContent">
			<ul>
			<li><a href="{$Config/AppPath}">首页</a></li>
			<li><a href="{$Config/AppPath}Board.aspx">讨论区</a></li>
			<li><a href="{$Config/AppPath}Photo.aspx">相册</a></li>
			<li><a href="{$Config/AppPath}Fellow.aspx">友情链接</a></li>
			<xsl:for-each select="$Pages">
			<li><a href="{$Config/AppPath}Page/{Page.Label}.aspx"><xsl:value-of select="Page.Title"/></a></li>
			</xsl:for-each>
			<li><a href="{$Config/AppPath}Tag.aspx">Tags</a></li>
			<li><a href="{$Config/AppPath}Feed.aspx">Feed RSS</a></li>
			<li><a href="{$Config/AppPath}Manage/Default.aspx">管理</a></li>
			</ul>
		</div>
		<div class="menuFoot" xml:space="preserve"> </div>
		</div>
	</xsl:template>

	<!--侧边栏-->
	<xsl:template name="SideBar">
		<xsl:param name="Config"/>
		<xsl:param name="Setting"/>
		<xsl:param name="Statistics"/>
		<xsl:param name="Categorys"/>
		<xsl:param name="Comments"/>
		<xsl:param name="Tags"/>
		<xsl:param name="Fellows"/>
		<xsl:param name="HotArticles"/>
		<xsl:param name="RandomArticles"/>
		<div class="sideBox">
			<div class="sideTop" xml:space="preserve"> </div>
			<div class="sideContent">
			<div class="affiche" xml:space="preserve">
				<xsl:value-of select="$Setting/Affiche" disable-output-escaping="yes"/>
			</div>
			<h1>文章分类</h1>
			<ul xml:space="preserve">
			<xsl:for-each select="$Categorys">
			<li><a href="{$Config/AppPath}Category/{Category.Label}.aspx"><xsl:value-of select="Category.Name"/></a> (<xsl:value-of select="Category.ArticleCount"/>)</li>
			</xsl:for-each>
			</ul>
			<h1>最新评论</h1>
			<ul xml:space="preserve">
			<xsl:for-each select="$Comments">
			<li><b><xsl:value-of select="string:Cut(Comment.Author, 6)"/></b>: <a href="{$Config/AppPath}Article/{Article.Label}.aspx#cmt_{Comment.ID}" title="{Comment.Content}"><xsl:value-of select="string:Cut(Comment.Content, 18)"/></a></li>
			</xsl:for-each>
			</ul>
			<h1>随机文章</h1>
			<ul xml:space="preserve">
			<xsl:for-each select="$RandomArticles">
			<li><a href="{$Config/AppPath}Article/{Article.Label}.aspx" title="{Article.Title}"><xsl:value-of select="string:Cut(Article.Title, 24)"/></a></li>
			</xsl:for-each>
			</ul>
			<h1>热门标签</h1>
			<ul xml:space="preserve">
			<xsl:for-each select="$Tags">
			<li><a href="{$Config/AppPath}Tag/{url:Encode(Tag.Name)}.aspx"><xsl:value-of select="Tag.Name"/></a>(<xsl:value-of select="Tag.ArticleCount"/>)</li>
			</xsl:for-each>
			</ul>
			<h1>系统信息</h1>
			<ul>
			<li>博主已经写了 <xsl:value-of select="$Statistics/ArticleCount"/> 篇日志</li>
			<li>网友总共发了 <xsl:value-of select="$Statistics/CommentCount"/> 条评论</li>
			<li>期间共上传了 <xsl:value-of select="$Statistics/AttachmentCount"/> 个附件</li>
			<li>本站已被访问 <xsl:value-of select="$Statistics/VisitCount"/> 次了</li>
			<li>备案信息：<a href="http://www.miibeian.gov.cn/" rel="external" xml:space="preserve"><xsl:value-of select="$Setting/ICP"/>
			</a></li>
			<li>TiSkin skin designer by csstemplates.org</li>
			</ul>
			<h1>合作伙伴</h1>
			<ul xml:space="preserve">
			<xsl:for-each select="$Fellows">
			<li><a href="{Fellow.URL}" rel="external"><xsl:value-of select="Fellow.Name"/></a><span><xsl:value-of select="Fellow.Explain"/></span></li>
			</xsl:for-each>
			</ul>
		</div>
		<div class="sideFoot" xml:space="preserve"> </div>
		</div>
	</xsl:template>

	<!--底部-->
	<xsl:template name="Bottom">
		<xsl:param name="Config"/>
		<div class="bottomBox">
			<div class="bottomTop" xml:space="preserve"> </div>
			<div class="bottomContent">
				Copyright © 2007 Foxcup.com. All rights reserved<br/>
				<xsl:value-of select="$Config/Powered" disable-output-escaping="yes"/>
			</div>
			<div class="bottomFoot" xml:space="preserve"> </div>
		</div>
	</xsl:template>

	<!--评论列表-->
	<xsl:template name="CommentList">
		<xsl:param name="Comments"/>
		<xsl:param name="Pages"/>
		<div class="pageBar">
			<span class="current">
				<xsl:value-of select="$Pages/Info/This"/>/<xsl:value-of select="$Pages/Info/Pages"/>
			</span>
			<xsl:for-each select="$Pages/Page">
				<xsl:if test="@Link!=''">
					<a href="{@Link}"><xsl:value-of select="@Text"/></a>
				</xsl:if>
				<xsl:if test="@Link=''">
					<span class="current"><xsl:value-of select="@Text"/></span>
				</xsl:if>
			</xsl:for-each>
		</div>
		<xsl:for-each select="$Comments">
			<div class="item">
				<div class="commentinfo">
					<b><xsl:if test="Comment.IsTB!='0'">引用<br/>通告</xsl:if><xsl:if test="Comment.IsTB='0'"><a href="{Comment.URL}" rel="external"><img src="http://www.gravatar.com/avatar.php?gravatar_id={common:GetGravatarID(Comment.Mail)}&amp;size=40"/></a></xsl:if></b>
					<span><a name="cmt_{Comment.ID}"><xsl:value-of select="Comment.Author"/></a></span>
					<br/><i><xsl:value-of select="Comment.Publish"/></i>
				</div>
				<div class="commenttext">
					<xsl:if test="Comment.IsTB!='0'"><xsl:value-of select="Comment.Content" disable-output-escaping="yes"/></xsl:if>
					<xsl:if test="Comment.IsTB='0'"><pre><xsl:value-of select="Comment.Content"/></pre></xsl:if>
				</div>
				<xsl:if test="Comment.Reply!=''">
					<div class="commentreply">
						<xsl:value-of select="Comment.Reply" disable-output-escaping="yes"/>
					</div>
				</xsl:if>
			</div>
		</xsl:for-each>
		<div class="pageBar">
			<span class="current"><xsl:value-of select="$Pages/Info/This"/>/<xsl:value-of select="$Pages/Info/Pages"/></span>
			<xsl:for-each select="$Pages/Page">
				<xsl:if test="@Link!=''"><a href="{@Link}"><xsl:value-of select="@Text"/></a></xsl:if>
				<xsl:if test="@Link=''"><span class="current"><xsl:value-of select="@Text"/></span></xsl:if>
			</xsl:for-each>
		</div>
	</xsl:template>

	<!--论板列表-->
	<xsl:template name="BoardList">
		<xsl:param name="Boards"/>
		<xsl:param name="Pages"/>
		<xsl:for-each select="$Boards">
			<div class="item" xml:space="preserve">
				<div class="boardinfo">
					<b onclick="javascript:window.open('{Board.URL}', '_blank');">个人网站</b>
					<span><a name="brd_{Board.ID}"><xsl:value-of select="Board.Author"/></a></span>
					[<xsl:value-of select="Board.Publish"/>]
				</div>
				<div class="boardtext">
					<pre><xsl:value-of select="Board.Content"/></pre>
				</div>
				<xsl:if test="Board.Reply!=''">
					<div class="boardreply">
						<xsl:value-of select="Board.Reply" disable-output-escaping="yes"/>
					</div>
				</xsl:if>
			</div>
		</xsl:for-each>
		<div class="pageBar">
			<span class="current"><xsl:value-of select="$Pages/Info/This"/>/<xsl:value-of select="$Pages/Info/Pages"/></span>
			<xsl:for-each select="$Pages/Page">
				<xsl:if test="@Link!=''"><a href="{@Link}"><xsl:value-of select="@Text"/></a></xsl:if>
				<xsl:if test="@Link=''"><span class="current"><xsl:value-of select="@Text"/></span></xsl:if>
			</xsl:for-each>
		</div>
	</xsl:template>
</xsl:stylesheet>