<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent" xml:space="preserve">
										<xsl:if test="Global.Setting/PlusPhotoSwitch='0'">
											相册功能还没有开放，暂时不可使用。
										</xsl:if>
										<xsl:if test="Global.Setting/PlusPhotoSwitch!='0'">
											<!--列表-->
											<div class="albums">
												<xsl:for-each select="This.Albums/Item">
												<div class="item">
													<div class="albumcover">
														<xsl:if test="Album.Cover=''">
															<a href="Photo/{Album.ID}.aspx"><img src="Common/Image/no_cover.png" width="180" height="120" border="0"/><xsl:value-of select="Fellow.Name"/></a>
														</xsl:if>
														<xsl:if test="Album.Cover!=''">
															<a href="Photo/{Album.ID}.aspx"><img src="{Album.Cover}" width="180" height="120" border="0"/><xsl:value-of select="Fellow.Name"/></a>
														</xsl:if>
													</div>
													<div class="albuminfo">
														<ul>
														<li>相册名称：<xsl:value-of select="Album.Name"/></li>
														<li>说　　明：<xsl:value-of select="Album.Intro"/></li>
														<li>创建日期：<xsl:value-of select="Album.Publish"/></li>
														</ul>
													</div>
												</div>
												</xsl:for-each>
											</div>
										</xsl:if>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>