﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:url="http://www.foxcup.com/url"
	>
	<xsl:output
		method="html"
		version="1.0"
		encoding="utf-8"
		omit-xml-declaration="no"
		media-type="application/xhtml+xml"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
		/>
	<xsl:include href="Include/UI.xsl"/>
	<xsl:template match="Roclog.UI">
		<xsl:variable name="Config" select="Global.Config"/>
		<html>
			<xsl:call-template name="Head">
				<xsl:with-param name="Config" select="Global.Config"/>
				<xsl:with-param name="Setting" select="Global.Setting"/>
				<xsl:with-param name="Title" select="This.Title"/>
			</xsl:call-template>
			<body>
				<div class="pageBox">
					<div class="pageTop" xml:space="preserve"> </div>
					<div class="pageContent">

						<!--头部块-->
						<xsl:call-template name="Top">
							<xsl:with-param name="Config" select="Global.Config"/>
							<xsl:with-param name="Setting" select="Global.Setting"/>
							<xsl:with-param name="Pages" select="Append.Pages/Item"/>
						</xsl:call-template>

						<!--middle-->
						<div class="middleBox">
							<div class="middleTop" xml:space="preserve"> </div>
							<div class="middleContent">

								<!--display-->
								<div class="displayBox">
									<div class="displayTop" xml:space="preserve"> </div>
									<div class="displayContent">
										<!--列表-->
										<div class="tags" xml:space="preserve">
											<xsl:for-each select="This.Tags/Item">
												<span class="item">
													<a href="{$Config/AppPath}Tag/{url:Encode(Tag.Name)}.aspx"><xsl:value-of select="Tag.Name"/></a>(<xsl:value-of select="Tag.ArticleCount"/>)　
												</span>
											</xsl:for-each>
										</div>

									</div>
									<div class="displayFoot" xml:space="preserve"> </div>
								</div>

								<!--边栏块-->
								<xsl:call-template name="SideBar">
									<xsl:with-param name="Config" select="Global.Config"/>
									<xsl:with-param name="Setting" select="Global.Setting"/>
									<xsl:with-param name="Statistics" select="Global.Statistics"/>
									<xsl:with-param name="Categorys" select="Append.Categorys/Item"/>
									<xsl:with-param name="Comments" select="Append.Comments/Item"/>
									<xsl:with-param name="HotArticles" select="Append.HotArticles/Item"/>
									<xsl:with-param name="RandomArticles" select="Append.RandomArticles/Item"/>
									<xsl:with-param name="Fellows" select="Append.Fellows/Item"/>
									<xsl:with-param name="Tags" select="Append.Tags/Item"/>
								</xsl:call-template>

							</div>
							<div class="middleFoot" xml:space="preserve"> </div>
						</div>

						<!--底部块-->
						<xsl:call-template name="Bottom">
							<xsl:with-param name="Config" select="Global.Config"/>
						</xsl:call-template>

					</div>
					<div class="pageFoot" xml:space="preserve"> </div>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>