﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet
  version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/1999/xhtml"
  xmlns:string="http://www.foxcup.com/string"
  >
  <xsl:output
    method="html"
    version="1.0"
    encoding="utf-8"
    omit-xml-declaration="no"
    media-type="application/xhtml+xml"
    indent="yes"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
    />
  <xsl:template match="/">
    <xsl:variable name="Source" select="Roclog.UI/This.Error/Source"/><!--发生错误的地方-->
    <xsl:variable name="Message" select="Roclog.UI/This.Error/Message"/><!--错误消息-->
    <xsl:variable name="StackTrace" select="Roclog.UI/This.Error/StackTrace"/><!--详细的错误内容-->
    <html>
      <head>
	<meta http-equiv="content-type" content="text/html; charset=utf-8" />
        <title>
          <xsl:value-of select="$Message"/>
        </title>
      </head>
      <body>
        <div id="errbox">
          <div class="RoundedCorner">
            <span class="rtop">
              <span class="r1"></span>
              <span class="r2"></span>
              <span class="r3"></span>
              <span class="r4"></span>
            </span>
            <div class="content">
              <div class="title">&#9432; 系统错误
            </div>
              <hr/>
              <div style="display:none;" id="StackTrace">
                <xsl:value-of select="$StackTrace"/>
              </div>
              <div class="errmsg">
                错误在 <xsl:value-of select="$Source"/> 中：<br/><br/>
                <a href="#" onclick="javascript:alert(document.getElementById('StackTrace').innerHTML);return false;">
                  <xsl:value-of select="$Message"/>
                </a>
              </div>
            </div>
            <span class="rbottom">
              <span class="r4"></span>
              <span class="r3"></span>
              <span class="r2"></span>
              <span class="r1"></span>
            </span>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>