﻿<%@ Page Language="C#" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master" AutoEventWireup="true" CodeBehind="AddCategory.aspx.cs" Inherits="EnjooSite.Web.Admin.Pages.AddCategory" Title="EnjooSite Admin - Add\Edit Categories" %>
<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>
<%@ Import Namespace="EnjooSite.Framework.Configuration" %>


<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a href='<%= UrlHelper.GetAdminCenterUrl() %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text") %>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text") %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <a href='<%= AdminCategoryUrl %>' title='<%= AdminCategoryTitle %>'><span><%= AdminCategoryTitle %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><asp:literal ID="LocationLiteral" runat="server"></asp:literal></label>
        </li>
    </ul>
</asp:Content>


<asp:Content ID="ContentActionsContent" ContentPlaceHolderID="ContentActionsContentPlace" runat="server">
    <ul class="vList clearfix menuButtons" id="contentActions">
        <li>
            <a href='<%= AddCategoryUrl %>' title='<%= UIText.GetSafeText("Button_NewCategory_Text") %>' id="addNewCategoryLink" class="new_category">
                <span><%= UIText.GetSafeText("Button_NewCategory_Text")%></span>
            </a>
        </li>
        <li class="separate">
            <span></span>
        </li>
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_Save_Text") %>' id="fitWindowLink" class="fitWindow">
                <span><%= UIText.GetSafeText("Button_FitWindow_Text") %></span>
            </a>
        </li>
    </ul>
</asp:Content>


<asp:Content ID="Content4" ContentPlaceHolderID="pageContent" runat="server">
	<st:MessagePanel id="Messages" runat="server" />
	
    <ul class="hList table_layout" style="padding-top:20px;" >
        <li>
            <label>栏目名称<asp:RequiredFieldValidator id="valtxbNewTitleRequired" runat="server" ControlToValidate="txbNewTitle" ValidationGroup="AddCategory"  ForeColor="#FF0000" ErrorMessage=" (标题不能为空)" /></label>
	        <asp:TextBox id="txbNewTitle" runat="server" CssClass="inline_text" ValidationGroup="AddCategory" />
        </li>
        <li>
            <div class="hSpace_10"></div>
            <ul class="vList clearfix">
                <li><label>栏目层级</label><asp:DropDownList ID="ParentCategoryDropDownList" runat="server"></asp:DropDownList></li>
                <li style="margin-right:20px;">&nbsp;</li>
                <li><label>分类标识图像</label><input class="FileUpload textbox" id="ImageFile" type="file" name="ImageFile" runat="server" style="width:250px;" /></li>
                <li style="margin-right:20px;">&nbsp;</li>
                <li><asp:CheckBox id="ckbNewIsActive" runat="server" Checked="true" CssClass="checkbox" Text="是否启用" TextAlign="Left" /></li>
            </ul>
        </li>
        <li>
            <st:RichTextEditor id="richTextEditor" runat="server" onerror="richTextEditor_Error" ToolbarSet="Simply" Height="200" />
        </li>
        <li style="display:none;">    
            <label>SortOrder
                <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="*" Text="*" ControlToValidate="txtSortOrder"  ValidationGroup="AddCategory"></asp:RequiredFieldValidator>
                <asp:RangeValidator ID="RangeValidator2" runat="server" ErrorMessage="*" Text="*" MinimumValue="0" MaximumValue="100" ValidationGroup="AddCategory" ControlToValidate="txtSortOrder" Type="Integer" Display="Dynamic"></asp:RangeValidator>
            </label>
	        <asp:TextBox ID="txtSortOrder" runat="server" ValidationGroup="AddCategory" CssClass="textbox" Width="25" Text="1"></asp:TextBox>
            
        </li>
        <li>            
            <div>
                <asp:LinkButton ID="DeleteLinkCategoryImageButton" OnClick="DeleteLinkCategoryImageButton_Click"  runat="server" Visible="false" Text="删除标识图像"></asp:LinkButton>
                <br />
                <asp:Image ID="LinkCategoryImage" runat="server" Visible="false" />
                <asp:HiddenField ID="LinkCategoryImageTextBox" runat="server" />
            </div>
        </li>
        <li>
            
        </li>
        <li>
            <asp:Button id="lkbPost" runat="server" CssClass="button" Text="确定" onclick="lkbPost_Click" ValidationGroup="AddCategory"  />
        </li>
    </ul>
    <div class="hSpace_10"></div>
    <div class="hSpace_10"></div>
    <script type="text/javascript">
        var currentFCKEditorInstanceId = '<%= richTextEditor.ClientID %>';
        $(function(e) {
            $("#savePostLink").click(function(e) {
                $(String.format("#{0}_lkbPost", '<%= richTextEditor.ClientID %>')).trigger("click"); return false;
            });
            $("#addNewCategoryLink").click(function(e) {
                //  $(String.format("#{0}_lkbPost", '<%= richTextEditor.ClientID %>')).trigger("click"); return false;
            });
            $("#fitWindowLink").click(function(e) {
                var oEditor = FCKeditorAPI.GetInstance(String.format("{0}_richTextEditor", "<%= richTextEditor.ClientID %>"));
                oEditor.Commands.GetCommand('FitWindow').Execute();
                return false;
            });
        });
    </script>
</asp:Content>
