﻿<%@ Page Language="C#" EnableTheming="false" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master" Codebehind="EditCategories.aspx.cs" AutoEventWireup="True" Inherits="EnjooSite.Web.Admin.Pages.EditCategories" %>
<%@ Import Namespace="EnjooSite.Framework.Configuration"%>
<%@ Import Namespace="EnjooSite.Framework.Components"%>
<%@ Import Namespace="EnjooSite.Web.Admin"%>
<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>

<asp:Content ID="UserProfileContent" ContentPlaceHolderID="UserProfileContentPlace" runat="server">
    <asp:ScriptManagerProxy id="ScriptManagerProxy1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="~/Scripts/Admin/ajaxHelper_Category.js" />
            <asp:ScriptReference Path="~/Common/Scripts/jQueryUI/jquery-ui-Dialog-1.5.3.min.js" />
        </Scripts>
    </asp:ScriptManagerProxy>
</asp:Content>


<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a href='<%= UrlHelper.GetAdminCenterUrl() %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text") %>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text") %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <a href='<%= AdminCategoryUrl %>' title='<%= AdminCategoryTitle %>'><span><%= AdminCategoryTitle %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_CategoriesManager_Text")  %></label>
        </li>
    </ul>
</asp:Content>


<asp:Content ID="ContentActionsContent" ContentPlaceHolderID="ContentActionsContentPlace" runat="server">
    <ul class="vList clearfix menuButtons" id="contentActions">
        <li>
            <a href='<%= AddCategoryUrl %>' title='<%= UIText.GetSafeText("Button_NewCategory_Text") %>' id="addNewCategoryLink" class="new_category">
                <span><%= UIText.GetSafeText("Button_NewCategory_Text")%></span>
            </a>
        </li>
        <li class="separate">
            <span></span>
        </li>
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_Delete_Text") %>' class="delete">
                <span><%= UIText.GetSafeText("Button_Delete_Text")%></span>
            </a>
        </li>
    </ul>
    <script type="text/javascript">
        if (typeof (window.__enjooSite_webPageClientIds) == "undefined" || window.__enjooSite_webPageClientIds == null) {
            window.__enjooSite_webPageClientIds = {};
        }
        window.__enjooSite_webPageClientIds.dgrItems = '<%= dgrItems.ClientID  %>';
    </script>
</asp:Content>


<asp:Content ID="entryEditor" ContentPlaceHolderID="pageContent" runat="server">
	<st:MessagePanel id="Messages" runat="server" />	
	
	<asp:PlaceHolder id="Edit" runat="server">
		<asp:DataGrid id="dgrItems" AutoGenerateColumns="False" GridLines="None" CssClass="listing" runat="server">
			<AlternatingItemStyle CssClass="alt"></AlternatingItemStyle>
			<HeaderStyle CssClass="Header"></HeaderStyle>

			<Columns>
			    <asp:TemplateColumn ItemStyle-Width="20">
			        <ItemTemplate>
			            <input type="radio" name="delete_radio" commandArgument='<%# ((LinkCategory)Container.DataItem).Id  %>' />
			        </ItemTemplate>
			    </asp:TemplateColumn>
				<asp:TemplateColumn HeaderText="名称">
					<ItemTemplate>
						<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Title") %>'></asp:Label>
						<div style="display:none;">
						    <br />
						    <asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Description") %>' ID="Label2" NAME="Label1"></asp:Label>
						</div>
					</ItemTemplate>

					<EditItemTemplate>
						<asp:Label runat="server" AssociatedControlID="txbTitle" Text="Title" /><br />
						<asp:TextBox CssClass="textbox" id="txbTitle" Width="400" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Title") %>' />
						<asp:Label runat="server" AssociatedControlID="txbTitle" Text="Description" /><br />
						
                        <st:RichTextEditor Width="400"  id="richTextEditorDescription" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Description") %>' onerror="richTextEditor_Error" />
					</EditItemTemplate>
				</asp:TemplateColumn>
				
				<asp:TemplateColumn HeaderText="是否启用">
					<ItemTemplate>
						<asp:Label runat="server" Text='<%# Convert.ToBoolean(Eval("IsActive"))==true?"是":"否" %>' />
					</ItemTemplate>

					<EditItemTemplate>
						<asp:CheckBox id="ckbIsActive" runat="server" Checked='<%# DataBinder.Eval(Container, "DataItem.IsActive") %>'/>
					</EditItemTemplate>
				</asp:TemplateColumn>
				
				<asp:TemplateColumn HeaderText="排序">
					<ItemTemplate>
						<asp:Label ID="Label1" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.SortOrder") %>' />
					</ItemTemplate>

					<EditItemTemplate>
					    <asp:TextBox ID="txtSortOrder" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.SortOrder") %>'  ValidationGroup="EditCategory" CssClass="textbox" Width="25"></asp:TextBox>
					    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="*" Text="*" ControlToValidate="txtSortOrder"  ValidationGroup="EditCategory"></asp:RequiredFieldValidator>
                        <asp:RangeValidator ID="RangeValidator1" runat="server" ErrorMessage="*" Text="*" MinimumValue="0" MaximumValue="100" ValidationGroup="EditCategory" ControlToValidate="txtSortOrder" Type="Integer" Display="Dynamic"></asp:RangeValidator>
					</EditItemTemplate>
				</asp:TemplateColumn>
				
				<asp:TemplateColumn>
				    <ItemTemplate>
				    <a href='<%# Config.CurrentBlog.AdminDirectoryVirtualUrl %>AddCategory.aspx?<%# GetCategoryIDKey()  %>=<%# Eval("ID") %>&<%# GetCategoryTypeKey() %>=<%# CurrentCategoryType %>'>编辑</a>
				    </ItemTemplate>
				</asp:TemplateColumn>
				
			</Columns>
		</asp:DataGrid>
	</asp:PlaceHolder>
	
	
</asp:Content>