<%@ Page Language="C#" EnableTheming="false" Title="EnjooSite Admin - Edit Image" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master" Codebehind="EditImage.aspx.cs" AutoEventWireup="True" Inherits="EnjooSite.Web.Admin.Pages.EditImage" %>
<%@ Register TagPrefix="st" TagName="CategoryLinks" Src="~/Admin/UserControls/CategoryLinkList.ascx" %>

<%@ Register TagPrefix="st" Namespace="EnjooSite.Web.Controls" Assembly="EnjooSite.Web.Controls" %>

<asp:Content ID="actions" ContentPlaceHolderID="actionsHeading" runat="server">
</asp:Content>

<asp:Content ID="categoryListTitle" ContentPlaceHolderID="categoryListHeading" runat="server">
    <h2>Images</h2>
</asp:Content>

<asp:Content ID="categoriesLinkListing" ContentPlaceHolderID="categoryListLinks" runat="server">
    <st:CategoryLinks ID="categoryLinks" runat="server" CategoryType="ImageCollection" />
</asp:Content>

<asp:Content ID="imageContent" ContentPlaceHolderID="pageContent" runat="server">
	<st:MessagePanel id="Messages" runat="server" />

	<st:AdvancedPanel id="ImageDetails" runat="server" Collapsible="false" HeaderText="Image Details" HeaderCssClass="CollapsibleHeader" BodyCssClass="Edit" DisplayHeader="True">
		
		<ASP:HyperLink id="lnkThumbnail" runat="server" Visible="false" CssClass="Thumbnail"></ASP:HyperLink>
		<p class="ThumbnailTitle">
			<%# Image.Title %>
			<br />
			<span><%# Image.Width.ToString() %>W x <%# Image.Height.ToString() %>H</span><br />
			<span><a href='<%# GetImageGalleryUrl() %>'><%# _galleryTitle %></a></span><br />
		</p>
		<br class="clear" />
		<label>Title</label>
		<ASP:TextBox id="txbTitle" runat="server" Text='<%# Image.Title %>' columns="255" width="98%" />
		
		<div>		    
	        <label>Image Description ( ignored for ZIP archives ) </label>
            <st:RichTextEditor id="richTextEditor" runat="server" onerror="richTextEditor_Error" />
		</div>
		<label>Gallery</label>
		<ASP:DropDownList id="ddlGalleries" runat="server" />
		<div class="button-div">
		
		    <asp:checkbox id="ckbPublished" runat="server" Text="Visible" />&nbsp;&nbsp;
		    
		    <asp:CheckBox ID="chkIsTop" runat="server" Text="Is Top" />&nbsp;&nbsp;
		    
		    <asp:CheckBox ID="chkDisplayOnHomepage" runat="server" Text="Display On Homepage" />
		    
		</div>
		<div class="button-div">
			<asp:linkbutton id="lkbUpdateImage" runat="server" CssClass="Button" Text="Update" onclick="lkbUpdateImage_Click" />
		</div>
		<p class="InlineSubtitle">Replace File</p>
		<label>Local File Location</label>
		<input id="ImageFile" class="FileUpload" type="file" size="82" runat="server" name="ImageFile" />
		<br class="clear" />		
		<div class="button-div">
			<asp:Button id="lbkAddImage" runat="server" CssClass="buttonSubmit" Text="Replace" onclick="lbkReplaceImage_Click" />
		</div>		
	</st:AdvancedPanel>	
	
	<st:AdvancedPanel id="Advanced" runat="server" LinkStyle="Image" LinkBeforeHeader="True" DisplayHeader="True" HeaderCssClass="CollapsibleTitle" LinkText="[toggle]" Collapsible="True" HeaderText="Advanced Options" BodyCssClass="Edit" Collapsed="true" HeaderTextCssClass="CollapsibleTitle">	
		<label>Original Image</label>
		<%# Image.OriginalFile %>
		<label>Thumbnail Image</label>
		<%# Image.ThumbNailFile %>
		<label>Resized Image</label>
		<%# Image.ResizedFile %>
	</st:AdvancedPanel>
</asp:Content>
