﻿<%@ Page Language="C#" MasterPageFile="Posts.Master" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="EnjooSite.Web.Admin.Posts.Default" %>
<%@ Register TagPrefix="st" Src="~/Admin/UserControls/EntriesList.ascx" TagName="EntriesList" %>

<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a href='<%= UrlHelper.GetAdminCenterUrl() %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text") %>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text") %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <a class="postManager" href='<%= UrlHelper.GetPostsManagerUrl() %>' title="<%= UIText.GetSafeText("Label_PostsManager_Text") %>"><span><%= UIText.GetSafeText("Label_PostsManager_Text") %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_MyPosts_Text") %></label>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="ContentActionsContent" ContentPlaceHolderID="ContentActionsContentPlace" runat="server">
    <ul class="vList clearfix menuButtons">
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_CheckAll_Text") %>' class="checkAll">
                <span><input type="checkbox" /><%= UIText.GetSafeText("Button_CheckAll_Text") %></span>
            </a>
        </li>
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_Delete_Text") %>' class="delete">
                <span><%= UIText.GetSafeText("Button_Delete_Text") %></span>
            </a>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="content" ContentPlaceHolderID="postsContent" runat="server">
    <st:MessagePanel id="Messages" runat="server" />
    <st:EntriesList id="entries" runat="server" EntryType="BlogPost" HeaderText="<%$ Resources:VSite,Label_Posts_Text %>" />
</asp:Content>