﻿<%@ Page Language="C#" EnableTheming="false"  Title="EnjooSite Admin - Security" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master" Codebehind="Security.aspx.cs" AutoEventWireup="True" Inherits="EnjooSite.Web.Admin.Pages.Security" %>


<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a class="admin-home" href='<%= UrlHelper.AdminUrl %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text")%>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text")%></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_SecurityEdit_Text")%></label>
        </li>
        <li style="float:right;">
            <label>上次更新时间：<%= UIText.NiceDateString( Config.CurrentBlog.LastUpdated) %></label>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="passwordContent" ContentPlaceHolderID="pageContent" runat="server">
    <st:MessagePanel id="Messages" runat="server"></st:MessagePanel>
    
	<div class="section enjoosite_portal_fullwidth">
	    <h5>修改密码</h5>
	    <div>
		    <label>当前密码
		        <asp:RequiredFieldValidator id="RequiredFieldValidator1" runat="server" ValidationGroup="ChangePassword" Display="Dynamic" ControlToValidate="tbCurrent"
				    ErrorMessage="Please enter your current passowrd" ForeColor="#990066"/>
		    </label>
		    <asp:TextBox id="tbCurrent" runat="server"  CssClass="inline_text" Width="200" TextMode="Password" />
		    <label>新密码
		    <asp:RequiredFieldValidator id="RequiredFieldValidator5" runat="server" ValidationGroup="ChangePassword" Display="Dynamic" ControlToValidate="tbPassword"
				    ErrorMessage="Please enter a password" ForeColor="#990066" />
		    <asp:CompareValidator id="CompareValidator1" runat="server" ValidationGroup="ChangePassword" Display="Dynamic" ControlToValidate="tbPasswordConfirm"
				    ErrorMessage="Your passwords do not match" ControlToCompare="tbPassword" ForeColor="#990066" /></label>
		    <asp:TextBox id="tbPassword" runat="server" CssClass="inline_text" Width="200" TextMode="Password" TabIndex="1" />
		    <label for="Edit_tbPasswordConfirm">再次输入新密码
		    <asp:RequiredFieldValidator id="RequiredFieldValidator6" runat="server" ValidationGroup="ChangePassword" Display="Dynamic" ControlToValidate="tbPasswordConfirm"
				    ErrorMessage="Please confirm your password" ForeColor="#990066" /></label>
		    <asp:TextBox id="tbPasswordConfirm" runat="server"  CssClass="inline_text" Width="200" TextMode="Password" TabIndex="2" />
    		
	        
			<div class="hSpace_10"></div>
		    <asp:Button id="btnChangePassword" runat="server" CssClass="buttonSubmit" Text="更新密码" onclick="btnChangePassword_Click" TabIndex="3" />
			<div class="hSpace_10"></div>
	    </div>
	
	    <h5>统一登陆设置（OpenID）</h5>
	    <div>
	        <label>OpenId管理地址</label>
			<asp:TextBox id="tbOpenIDURL" runat="server" CssClass="inline_text" Width="350" />
			<div class="hSpace_10"></div>
			<asp:Button id="btnSaveOptions" runat="server" CssClass="buttonSubmit" Text="更新OpenId地址" onclick="btnSaveOptions_Click" TabIndex="6" />
			<div class="hSpace_10"></div>
		</div>
	</div>
	
</asp:Content>