﻿<%@ Page Language="C#" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master"  AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="EnjooSite.Web.Admin.SilverAlbumManager.Default" %>

<asp:Content ID="UserProfileContent" ContentPlaceHolderID="UserProfileContentPlace" runat="server">
    <asp:ScriptManagerProxy id="ScriptManagerProxy1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="~/Scripts/Admin/ajaxHelper_SilverAlbumManager.js" />
            <asp:ScriptReference Path="~/Common/Scripts/jQueryUI/jquery-ui-sortable_dialog-1.5.3.packed.js" />
        </Scripts>
    </asp:ScriptManagerProxy>
</asp:Content>

<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <a href='<%= UrlHelper.GetAdminCenterUrl() %>' title='<%= UIText.GetSafeText("Label_AdminCenter_Text") %>'><span><%= UIText.GetSafeText("Label_AdminCenter_Text") %></span></a>
        </li>
        <li class="vSeparate">
            <span>»</span>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_AlbumManager_Text")%></label>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="ContentActionsContent" ContentPlaceHolderID="ContentActionsContentPlace" runat="server">
    <ul class="vList clearfix menuButtons" id="silverAlbumActions">
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_AddSilverAlbum_Text") %>' class="add_silveralbum">
                <span><%= UIText.GetSafeText("Button_AddSilverAlbum_Text")%></span>
            </a>
        </li>
        <li class="separate">
            <span></span>
        </li>
        <li>
            <a href="#" title='<%= UIText.GetSafeText("Button_Delete_Text") %>' class="delete">
                <span><%= UIText.GetSafeText("Button_Delete_Text")%></span>
            </a>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="content" ContentPlaceHolderID="pageContent" runat="server">

    <asp:Repeater id="SilverAlbumRepeater" runat="server">
	    <HeaderTemplate>
		    <table id="SilverAlbumListing" class="listing highlightTable" cellspacing="0" cellpadding="0" border="0">
		        <thead>
			        <tr>
			            <th width="25">&nbsp;</th>
				        <th valign="middle">
				            <%= UIText.GetSafeText("VSite", "Label_SilverAlbumTitle_Text", string.Empty)%>
				        </th>
				        <th valign="middle"><%= UIText.GetSafeText("Label_Gallery_Title")%></th>
				        <th width="75" valign="middle">
				            <%= UIText.GetSafeText("VSite","Label_SilverAlbumImageCount_Text",string.Empty) %>
				        </th>
				        <th width="50" valign="middle"><%= UIText.GetSafeText("Label_ActiveState_Title")%></th>
				        <th width="125" valign="middle">
				            <%= UIText.GetSafeText("VSite","Label_DataAdded_Text" , string.Empty ) %>
				        </th>
				        <th width="50">&nbsp;</th>
			        </tr>
			    </thead
			    <tbody>
	    </HeaderTemplate>
	    <ItemTemplate>
		    <tr>
		        <td>
		            <input type="checkbox" commandArgument='<%# ((SilverAlbum)Container.DataItem).SilverAlbumId %>' />
		        </td>
			    <td><a href='<%# Config.CurrentBlog.UrlFormats.SilverAlbumUrl(((SilverAlbum)Container.DataItem).SilverAlbumId) %>' target="_blank"><%# ((SilverAlbum)Container.DataItem).Title %></a></td>
			    <td><a href='<%# Config.CurrentBlog.UrlFormats.GalleryUrl(string.Empty,((SilverAlbum)Container.DataItem).GalleryId) %>' target="_blank"><%# ((SilverAlbum)Container.DataItem).GalleryTitle %></a></td>
			    <td>
				    <%# ((SilverAlbum)Container.DataItem).Images.Count %>
			    </td>	
			    <td><%# ((SilverAlbum)Container.DataItem).IsActive?"开放":"关闭" %></td>											
			    <td>
				    <%# UIText.NiceDateString(((SilverAlbum)Container.DataItem).DateAdded )%>
			    </td>
			    <td>
				    <a href="AddSilverAlbum.aspx?SilverAlbumId=<%# Eval("SilverAlbumId") %>" title="修改">
				        <%= UIText.GetSafeText("VSite" , "Link_Edit_Text" , string.Empty )  %>
				    </a>
			    </td>
		    </tr>
	    </ItemTemplate>
	    <AlternatingItemTemplate>
	        <tr class="alt">
		        <td>
		            <input type="checkbox" commandArgument='<%# ((SilverAlbum)Container.DataItem).SilverAlbumId %>' />
		        </td>
			    <td><a href='<%# Config.CurrentBlog.UrlFormats.SilverAlbumUrl(((SilverAlbum)Container.DataItem).SilverAlbumId) %>' target="_blank"><%# ((SilverAlbum)Container.DataItem).Title %></a></td>
			    <td><a href='<%# Config.CurrentBlog.UrlFormats.GalleryUrl(string.Empty,((SilverAlbum)Container.DataItem).GalleryId) %>' target="_blank"><%# ((SilverAlbum)Container.DataItem).GalleryTitle %></a></td>
			    <td>
				    <%# ((SilverAlbum)Container.DataItem).Images.Count %>
			    </td>	
			    <td><%# ((SilverAlbum)Container.DataItem).IsActive?"开放":"关闭" %></td>												
			    <td>
				    <%# UIText.NiceDateString(((SilverAlbum)Container.DataItem).DateAdded )%>
			    </td>
			    <td>
				    <a href="AddSilverAlbum.aspx?SilverAlbumId=<%# Eval("SilverAlbumId") %>" title="修改">
				        <%= UIText.GetSafeText("VSite" , "Link_Edit_Text" , string.Empty )  %>
				    </a>
			    </td>
	        </tr>
	    </AlternatingItemTemplate>
	    <FooterTemplate>
	        </tbody>
		    </table>
	    </FooterTemplate>
    </asp:Repeater>

    <div id="addSilverAlbum_Container" style="display:none;">
        <h5><%= UIText.GetSafeText("Label_SilverAlbumTitle_Text") %></h5>
        <input type="text" class="simply_text" />
        <h5>相册专辑</h5>
        <ul class="v_list">
        <asp:Repeater ID="GalleriesRepeater" runat="server">
            <ItemTemplate>
                <li style="margin:0;padding:0;">
                    <ul class="h_list clearfix"><li><input type="radio" id='<%# string.Format("Gallery_{0}_Radio",Eval("Id")) %>' value='<%# Eval("Id") %>' name="Galleries" <%# Container.ItemIndex<=0?"checked=\"checked\"":string.Empty %>  /></li><li><label for='<%# string.Format("Gallery_{0}_Radio",Eval("Id")) %>'><%# Eval("Title") %></label></li></ul>
                </li>                
            </ItemTemplate>
        </asp:Repeater>
        </ul>
        <div class="hSpace_10" style="border-top:1px dashed #ccc;"></div>
        <a href="#" style="margin-left:10px;"><span style="cursor:pointer;"><%= UIText.GetSafeText("Button_Yes_Text")%></span></a>
        <div class="hSpace_10"></div>   
    </div>

</asp:Content>