﻿<%@ Page Language="C#" MasterPageFile="~/Admin/WebUI/AdminPageTemplate.Master" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="EnjooSite.Web.Admin.Pages.HomePageDefault" %>


<asp:Content ID="UserProfileContent" ContentPlaceHolderID="UserProfileContentPlace" runat="server">
    <asp:ScriptManagerProxy id="ScriptManagerProxy1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="~/Scripts/Admin/ajaxHelper_AdminHomePage.js" />
            <asp:ScriptReference Path="~/Common/Scripts/jQueryUI/jquery-ui-Dialog-1.5.3.min.js" />
        </Scripts>
    </asp:ScriptManagerProxy>
</asp:Content>

<asp:Content ID="LocationContent" ContentPlaceHolderID="ContentLocationContentPlace" runat="server">
    <ul class="vList content_location clearfix">
        <li>
            <b><%= UIText.GetSafeText("Label_Location_Text")%></b>
        </li>
        <li>
            <label><%= UIText.GetSafeText("Label_AdminCenter_Text") %></label>
        </li>
        <li style="float:right;">
            <label>上次更新时间：<%= UIText.NiceDateString( Config.CurrentBlog.LastUpdated) %></label>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="ContentActionsContent" ContentPlaceHolderID="ContentActionsContentPlace" runat="server">
    <ul class="vList clearfix menuButtons">
        <li>
            <span>基本信息</span>
        </li>
    </ul>
</asp:Content>

<asp:Content ID="content" ContentPlaceHolderID="pageContent" runat="server">
    <div class="hSpace_10"></div>
    <div class="grid_4 alpha">
        <h5 style="padding:0 0 5px 0;border-bottom:1px dotted #dcdcdc;margin:0 0 10px 10px;color:#06c;">
            (<%= Config.CurrentBlog.BlogGroupTitle %>)
            <%= Config.CurrentBlog.Title %>
        </h5>
        <div class="grid_2 alpha">
            <ul style="margin:0 0 0 10px;" class="hList">
                <li>
                    <div  style="margin:0 auto;text-align:center;">
                        <img src='<%= string.Format("{0}?guid={1}", Config.CurrentBlog.SmallLogoUrl,Guid.NewGuid().ToString("N")) %>' alt="UserAvatar" class="user-avatar" />
                        <div class="hSpace_10"></div>
                        <a href='<%= UrlHelper.ProfileEditUrl %>'>修改头像</a>
                    </div>
                    
                </li>
            </ul>
        </div>
        <div class="grid_2 omega">
            <ul class="hList clearfix" style="line-height:150%;">
                <li><label>用户名：</label><%= Config.CurrentBlog.UserName %></li>
                <li><label>友好名：</label><%= Config.CurrentBlog.Author %></li>
                <li><label>内部ID：</label><%= Config.CurrentBlog.Id %></li>
                <li><label>总积分：</label><%= Config.CurrentBlog.Fortune %></li>
                <li><label>文章数：</label><%= Config.CurrentBlog.PostCount %></li>
                <li><label>评论数：</label><%= Config.CurrentBlog.CommentCount %></li>
            </ul>
        </div>
    </div>
    <div class="grid_6 omega">        
        <h5 style="padding:0 0 5px 0;border-bottom:1px dotted #dcdcdc;margin:0 0 10px 10px;color:#06c;">系统公告</h5>
    </div>
    <div class="clear"></div>
    <h5 style="line-height:35px;height:35px;background:#f6f6f6;border-bottom:1px solid #d9d9d9;padding:0 30px;font-weight:normal;">快速入口</h5>
    <div class="enjoosite-portal">
        <ul class="vList clearfix float-button">
            <li>
                <a href='<%= UrlHelper.NetDiskManagerUrl %>'>
                    <span class="netdisk icon">.</span>
                    <span class="title">网络硬盘</span>
                    自由、超大空间
                </a>
            </li>
            <li>
                <a href='<%= UrlHelper.SilverAlbumManagerUrl %>'>
                    <span class="silveralbum icon">.</span>
                    <span class="title">动感相册</span>
                    个性、自由的动感相册视频
                </a>
            </li>
            <li>
                <a href='<%= UrlHelper.GetAddPostUrl() %>'>
                    <span class="post icon">.</span>
                    <span class="title">发布文章</span>
                    点滴记忆，只要书写就好
                </a>
            </li>
            <li>
                <a href='<%= UrlHelper.ConfigureEditUrl %>'>
                    <span class="profile icon">.</span>
                    <span class="title">编辑我的资料</span>
                    设置与众不同的个性资料
                </a>
            </li>
            <li>
                <a href='<%= UrlHelper.SecurityEditUrl %>'>
                    <span class="security icon">.</span>
                    <span class="title">更新密码</span>
                    请您定期更新密码
                </a>
            </li>
        </ul>
    </div>
    
    <div class="clear"></div>
    <h5 style="line-height:35px;height:35px;background:#f6f6f6;border-bottom:1px solid #d9d9d9;padding:0 30px;font-weight:normal;">最新短消息</h5>
</asp:Content>