﻿
// Descendant testing.
jQuery.comparePosition = function(element, context) {
    if ('compareDocumentPosition' in document.documentElement) {
        arguments.callee = function(element, context) {
            return !!(context.compareDocumentPosition(element) & 16);
        }
    } else if ('contains' in document.documentElement) {
        arguments.callee = function(element, context) {
            return (element != context && context.contains(element));
        }
    } else {
        arguments.callee = function(element, context) {
            for (var parent = element; parent != context; parent = parent.parentNode)
                if (!parent) return false;
            return true;
        }
    }
    return arguments.callee(element, context);
};

jQuery.fn.ancestorOf = function(context) {
    return this.filter(function() {
        return jQuery.comparePosition(context, this);
    });
};
jQuery.fn.descendantOf = function(context) {
    return this.filter(function() {
        return jQuery.comparePosition(this, context);
    });
};