﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="ManageChannel.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.ManageChannel" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript">
        $(function() {
            parent.topFrame.hideAlert();
            //tabs
            $('#tabs>ul').tabs();
            $("a[commandName=return]").bind("click", showLoading);
        })
        function showLoading(e) {
            parent.topFrame.isPostback = false;
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
        };
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">

    <st:MessagePanel id="Messages" runat="server" />
    

    <h5>
        <a href="HostChannelsList.aspx" commandName="return"><%= UIText.GetSafeText("VSite","Label_Return_Text",string.Empty) %></a>
        <%= UIText.GetSafeText("VSite","Label_CurrentAction_Text",string.Empty) %>：
        <% if (Request.QueryString["catid"] != null)
           { %>
            <%= UIText.GetSafeText("SiteMenu", "HostAdmin_HostChannel_Edit", string.Empty)%>
        <% }else{ %>
            <%= UIText.GetSafeText("SiteMenu", "HostAdmin_HostChannel_Add", string.Empty)%>
        <% } %>
    </h5>
    <br />
        
    <div class="vForm">    
    
        <div id="tabs">
            <ul>
                <li class="ui-tabs-nav-item"><a href="#fragment-1">基本信息</a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-2">高级设置</a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-3"><span>频道定制</span></a></li>
            </ul>
            <div id="fragment-1" style="position:relative;">
            
                <label>
                    Channel's Image
                </label>
                <input class="FileUpload" id="ImageFile" type="file" size="36" name="ImageFile" runat="server" />
                <div style="position:absolute;left:380px;top:40px;z-index:900;">
                    <asp:LinkButton ID="DeleteLinkCategoryImageButton" OnClick="DeleteLinkCategoryImageButton_Click" runat="server" Visible="false" Text="删除标识图像"></asp:LinkButton>
                    <br />
                    <asp:Image ID="LinkCategoryImage" runat="server" Visible="false" />
                    <asp:HiddenField ID="LinkCategoryImageTextBox" runat="server" />
                </div>
                <br />
                <br />
                <label>
                    Title &nbsp;<asp:RequiredFieldValidator ID="valtxbNewTitleRequired" runat="server"
                        ControlToValidate="txbNewTitle" ValidationGroup="AddCategory" ForeColor="#990066"
                        ErrorMessage="Your category must have a description" />
                </label>
                <asp:TextBox ID="txbNewTitle" runat="server" Width="320" ValidationGroup="AddCategory" />
      
                <br /><br />
                
                
                
                <label>
                    Description (1000 characters including HTML)
                </label>
                <st:RichTextEditor ID="richTextEditor" runat="server" OnError="richTextEditor_Error" />
            
            
            </div>
            <div id="fragment-2">
          
                <table class="listing" style="width:700px;margin-top:20px;" border="0" cellpadding="0" cellspacing="0">
                    <thead>
                        <tr>
                            <th>
                                <label>
                                    Parent Category
                                </label>
                            </th>
                            <th>
                                <label>
                                    <%= UIText.GetSafeText("VSite", "Label_ChannelSkin_Text", string.Empty)%>
                                </label>
                            </th>
                            <th>
                                <label>
                                    SortOrder
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="*" Text="*" ControlToValidate="txtSortOrder" ValidationGroup="AddCategory"></asp:RequiredFieldValidator>
                                    <asp:RangeValidator ID="RangeValidator2" runat="server" ErrorMessage="*" Text="*" MinimumValue="0" MaximumValue="100" ValidationGroup="AddCategory" ControlToValidate="txtSortOrder" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                </label>
                            </th>
                            <th>
                                <label>
                                    状态
                                </label>
                            </th>
                        </tr>
                    </thead>
                    <tr>
                        <td>                    
                            <asp:DropDownList ID="ParentCategoryDropDownList" runat="server">
                            </asp:DropDownList>
                        </td>
                        <td>
                            <asp:DropDownList ID="ChannelSkinDropDownList" runat="server"></asp:DropDownList>
                        </td>
                        <td>
                            <asp:TextBox ID="txtSortOrder" runat="server" ValidationGroup="AddCategory" CssClass="textbox" Text="0" Width="25"></asp:TextBox>
                        </td>
                        <td>
                            <asp:CheckBox ID="ckbNewIsActive" runat="server" Checked="true" CssClass="checkbox" Text="是否启用" />
                        </td>
                    </tr>
                </table>
            
                <br />
                <br />
                
                <label>
                    频道模板预览
                </label>
                <div>
                    
                </div>
            </div>
            <div id="fragment-3">
                <label>
                    Main Banner
                </label>
                <div>                             
                    <st:RichTextEditor ID="richTextEditor_MainBanner" runat="server"   OnError="richTextEditor_Error" />
                </div>
                <br />
                <label>
                    SideBar Banner
                </label>
                <div>                
                    <st:RichTextEditor ID="richTextEditor_SideBarBanner" runat="server"  OnError="richTextEditor_Error" />
                </div>

            </div>
        </div>      
        

        <div class="buttons">
            <br />
            <asp:Button ID="lkbPost" runat="server" CssClass="button" Text="Add/Update" OnClick="lkbPost_Click" ValidationGroup="AddCategory" />
        </div>
    </div>


</asp:Content>
