﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="RssManager.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.RssManager" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
<script type="text/javascript">
    var _currentLocation = '<%= VirtualPathUtility.ToAbsolute("~/HostAdmin/Frame_Main/RssManager.aspx") %>';
</script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="~/Scripts/HostAdmin/RssManager.js" />
        </Scripts>
    </asp:ScriptManagerProxy>
    <st:MessagePanel id="Messages" runat="server" />
    <h5>
        当前操作：<%= UIText.GetSafeText("SiteMenu", "MainMenu_RssEdit_Text", string.Empty)%>
    </h5>
    <br />
    
        <div id="tabs">
            <ul>
                <li class="ui-tabs-nav-item"><a href="#fragment-1"><%= UIText.GetSafeText("SiteMenu", "Rss_Edit_Title", string.Empty)%></a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-2"><%= UIText.GetSafeText("SiteMenu", "Rss_Add_Title", string.Empty)%></a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-3"><%= UIText.GetSafeText("SiteMenu", "RssCategory_Add_Title", string.Empty)%></a></li>
            </ul>
            <div id="fragment-1" style="position:relative;padding:10px 0;">            
                <asp:Repeater ID="RssCategoriesRepeater" runat="server">
                    <HeaderTemplate>
                        <ul id="rssCategoriesContainer" style="list-style-type:none;margin:0px;padding:0px;">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li id='<%# string.Format("rssCategory_{0}",Eval("ID").ToString()) %>' commandArgument='<%# Eval("ID") %>'>
                            [<a href="#" commandName="deleteRssCategory" commandArgument='<%# Eval("ID") %>'>X</a>] 
                            <span class="catName" style="font-weight:bold;">
                                <%# Eval("Title")  %>
                            </span>
                            <a href="#" commandName="up" commandArgument='<%# Eval("ID") %>' title="上移">↑</a>
                            <a href="#" commandName="down" commandArgument='<%# Eval("ID") %>' title="下移">↓</a>
                            <br />
                            <ol commandArgument='<%# Eval("ID") %>'>
                            <asp:Repeater ID="RssRepeater" runat="server">
                                <ItemTemplate>
                                    <li id='<%# string.Format("rss_{0}",Eval("RssID").ToString()) %>' commandArgument='<%# Eval("RssID") %>'>
                                        [<a href="#" commandName="deleteRss" commandArgument='<%# Eval("RssID") %>'>X</a>] 
                                        <a target="_blank" href='<%# string.Format("{0}",Eval("RssUrl").ToString()) %>'>
                                            <%# Eval("Title") %>
                                        </a>
                                        <a href="#" commandName="up" commandArgument='<%# Eval("RssID") %>' title="上移">↑</a>
                                        <a href="#" commandName="down" commandArgument='<%# Eval("RssID") %>' title="下移">↓</a>
                                    </li>
                                </ItemTemplate>
                            </asp:Repeater>
                            </ol>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                    </FooterTemplate>
                </asp:Repeater>
            
            </div>
            <div id="fragment-2" style="line-height:250%;padding:10px">
                <h5><%= UIText.GetSafeText("SiteMenu", "SystemLinks_Category_Title", string.Empty)%></h5>
                <asp:Repeater ID="RssCategoriesRepeater2" runat="server">
                    <HeaderTemplate>
                        <ul id="rssCategoriesContainer2" style="list-style-type:none;margin:0px;" class="clearfix">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li style="float:left;display:block;width:100px;">
                            <input type="radio" name="rssCategory" <%# Container.ItemIndex==0?"checked=\"checked\"":"" %> commandArgument='<%#  Eval("Id") %>' id='<%# string.Format("RssCategory_{0}", Eval("Id").ToString()) %>' /><label style="font-weight:normal;" for='<%# string.Format("RssCategory_{0}", Eval("Id").ToString()) %>'><%# Eval("Title") %></label>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                    </FooterTemplate>
                </asp:Repeater>
                <br />
                <label>请输入RSS订阅地址或目标网址(<span style="font-weight:normal;color:#398cd6;">系统将自动发现可能存在的RSS订阅地址</span>)</label><br />
                <label>地址：</label><input type="text" class="niceTxt" id="rssUrlTextBox" style="width:200px;" /><br />
                
                <br />
                
                <input type="button" class="niceButton" id="saveRssButton" value="保存Rss订阅" />
            </div>
            <div id="fragment-3">
                <label>Rss订阅分类名称：</label>
                <br />
                <input type="text" class="niceTxt" id="categoryTextBox" />
                <br />
                <br />
                <input type="button" class="niceButton" id="saveCategoryButton" value="保存Rss订阅分类" />
            </div>
        </div>   
</asp:Content>
