﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="SystemLinks.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.SystemLinks" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">        
    <script type="text/javascript">
        $(function(e) {
            parent.topFrame.hideAlert();
            $('#tabs>ul').tabs();
            $("a[commandName=Delete]").bind("click", deleteSystemLink);
            $("#saveSystemLinkButton").bind("click", saveSystemLinkButton);
            $("#saveSystemLinkCategoryButton").bind("click", saveSystemLinkCategoryButton);
            $("ul.systemLinks>li>a[commandName=delete]").bind("click", deleteSystemLinkCategory);
            updateSortLinks();
            updateSortLinkCategories();
        });

        function deleteSystemLinkCategory(e) {
            if (confirm("确定删除当前分类？\r\n\r\n请注意：当前操作将同步删除关联链接。")) {
                var currentSystemLinkCategoryId = $(this).attr("commandArgument");
                PageMethods.DeleteSystemLinkCategory(
                    currentSystemLinkCategoryId,
                    function(result, userContext, methodName) {
                        resut = eval("(" + resut + ")");
                        if (resut.type == "success") {
                            $(userContext).remove();
                            updateSortLinkCategories();
                        };
                        parent.topFrame.displayAlert(null, resut);
                    },
                    function(error, userContext, methodName) {
                        parent.topFrame.displayAlert(null, { message: error.get_message, type: "error", autoHide: true });
                    },
                    $(String.format("#systemLinkCategory_{0}", currentSystemLinkCategoryId))
                );
            };
            return false;
        };

        function saveSystemLinkCategoryButton(e) {
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
            var categoryTitle = $("#linkCategoryTextBox").val().trim();
            if (categoryTitle != "") {
                PageMethods.SaveSystemLinkCategory(
                    categoryTitle,
                    function(result, userContext, methodName) {
                        result = eval("(" + result + ")");
                        parent.topFrame.isPostback = true;
                        if (result.type == "success") {
                            window.location = window.location;
                        };
                        parent.topFrame.displayAlert(null, result);
                    },
                    function(error, userContext, methodName) {
                        parent.topFrame.displayAlert(null, { message: error.get_message, type: "error", autoHide: true });
                    },
                    null
                );
            } else {
                parent.topFrame.displayAlert(null, { message: "分类名称不能为空！", type: "error", autoHide: true });
            };
            $(this).blur();
            return false;
        };

        function deleteSystemLink(e) {
            if (confirm("确认删除当前链接？")) {
                parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
                var linkID = $(this).attr("commandArgument");
                PageMethods.DeleteSystemLink(
                    linkID,
                    function(resut, userContext, methodName) {
                        resut = eval("(" + resut + ")");
                        if (resut.type == "success") {
                            var currentLi = $(userContext).parent().parent();
                            currentLi.remove();
                        };
                        parent.topFrame.displayAlert(null, resut);
                    },
                    function(error, userContext, methodName) {
                        parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                    },
                    $(this)
                );
            };
            return false;
        };

        function saveSystemLinkButton(e) {
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
            var categoryID = $("input:checked", $("#systemLinkCategoriesContainer")).eq(0).attr("commandArgument");
            var title = $("#linkTitleTextBox").val().trim();
            var url = $("#linkUrlTextBox").val().trim();
            if (title != "" && url != "") {
                if (!isURL(url)) {
                    parent.topFrame.displayAlert(null, { message: "无效URL地址信息！", type: "error", autoHide: true });
                } 
                else {
                    PageMethods.SaveSystemLink(title, url, categoryID,
                        function(result, userContext, methodName) {
                            result = eval("(" + result + ")");
                            if (result.type == "success") {
                                parent.topFrame.isPostback = true;
                                window.location = window.location;
                            };
                            parent.topFrame.displayAlert(null, result);
                        },
                        function(error, userContext, methodName) {
                            parent.topFrame.displayAlert(null, { message: error.get_message(), type: "alert", autoHide: true });
                        },
                        $(this)
                    );
                };
            } else {
                parent.topFrame.displayAlert(null, { message: "标题、地址信息不能为空！", type: "alert", autoHide: true });
            };
            $(this).blur();
            return false;
        };

        function updateSortLinks() {
            $("ol>li>span.site>a[commandName=up]").show();
            $("ol>li>span.site>a[commandName=down]").show();
            $("ol>li:first-child>span.site>a[commandName=up]").hide();
            $("ol>li:last-child>span.site>a[commandName=down]").hide();
            $("ol>li>span.site>a[commandName=up]").unbind("click");
            $("ol>li>span.site>a[commandName=down]").unbind("click");
            $("ol>li>span.site>a[commandName=up]").bind("click", moveUp);
            $("ol>li>span.site>a[commandName=down]").bind("click", moveDown);
        };

        function updateSortLinkCategories() {
            $("ul.systemLinks>li>a[commandName=up]").show();
            $("ul.systemLinks>li>a[commandName=down]").show();
            $("ul.systemLinks>li:first-child>a[commandName=up]").hide();
            $("ul.systemLinks>li:last-child>a[commandName=down]").hide();
            $("ul.systemLinks>li>a[commandName=up]").unbind("click");
            $("ul.systemLinks>li>a[commandName=down]").unbind("click");
            $("ul.systemLinks>li>a[commandName=up]").bind("click", moveCategoryUp);
            $("ul.systemLinks>li>a[commandName=down]").bind("click", moveCategoryDown);
        };

        function moveUp(e) {
            var sourceLink = $(String.format("#systemLink_{0}", $(this).attr("commandArgument")));
            var toLink = sourceLink.prev();
            moveLink(sourceLink, toLink);
            return false;
        };
        function moveDown(e) {
            var sourceLink = $(String.format("#systemLink_{0}", $(this).attr("commandArgument")));
            var toLink = sourceLink.next();
            moveLink(toLink, sourceLink);
            return false;
        };

        function moveCategoryUp(e) {
            var sourceLink = $(String.format("#systemLinkCategory_{0}", $(this).attr("commandArgument")));
            var toLink = sourceLink.prev();
            moveLinkCategory(sourceLink, toLink);
            return false;
        };
        function moveCategoryDown(e) {
            var sourceLink = $(String.format("#systemLinkCategory_{0}", $(this).attr("commandArgument")));
            var toLink = sourceLink.next();
            moveLinkCategory(toLink , sourceLink);
            return false;
        };

        function moveLink(fromLink, toLink) {
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
            var linkID1 = $(fromLink).attr("commandArgument");
            var linkID2 = $(toLink).attr("commandArgument");
            PageMethods.UpdateSystemLinkSort(linkID1, linkID2,
                function(result, userContext, methodName) {
                    result = eval("(" + result + ")")
                    if (result.type == "success") {
                        fromLink.insertBefore(toLink);
                        updateSortLinks();
                    };
                    parent.topFrame.displayAlert(null, result);
                },
                function(error, userContext, methodName) {
                    parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                },
                { fromLink: fromLink, toLink: toLink }
            );
            }
        
        function moveLinkCategory(fromLink, toLink) {
            var linkCategoryID1 = $(fromLink).attr("commandArgument");
            var linkCategoryID2 = $(toLink).attr("commandArgument");
            PageMethods.UpdateSystemLinkCategorySort(linkCategoryID1, linkCategoryID2,
                function(result, userContext, methodName) {
                    result = eval("(" + result + ")")
                    if (result.type == "success") {
                        fromLink.insertBefore(toLink);
                        updateSortLinkCategories();
                    };
                    parent.topFrame.displayAlert(null, result);
                },
                function(error, userContext, methodName) {
                    parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                },
                { fromLink: fromLink, toLink: toLink }
            );
        }
        
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>
    <st:MessagePanel id="Messages" runat="server" />
    <h5>
        当前操作：网站|网页链接维护
    </h5>
    <br />
    
        <div id="tabs">
            <ul>
                <li class="ui-tabs-nav-item"><a href="#fragment-1"><%= UIText.GetSafeText("SiteMenu", "SystemLinks_Edit_Title", string.Empty)%></a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-2"><%= UIText.GetSafeText("SiteMenu","SystemLinks_Add_Title",string.Empty ) %></a></li>
                <li class="ui-tabs-nav-item"><a href="#fragment-3"><%= UIText.GetSafeText("SiteMenu","SystemLinks_AddCategory_Title",string.Empty ) %></a></li>
            </ul>
            <div id="fragment-1" style="position:relative;padding:10px 0;">            
                <asp:Repeater ID="SystemLinkCategoriesRepeater" runat="server">
                    <HeaderTemplate>
                        <ul class="systemLinks" style="list-style-type:none;margin:0px;padding:0px;">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li id='<%# string.Format("systemLinkCategory_{0}",Eval("Id").ToString()) %>' commandArgument='<%# Eval("Id") %>'>
                            [<a href="#" commandName="delete" commandArgument='<%# Eval("Id") %>'>X</a>] 
                            <span class="catName" style="font-weight:bold;">
                                <%# Eval("Title")  %>
                            </span>                            
                            <a href="#" commandName="up" commandArgument='<%# Eval("Id") %>' title="上移">↑</a>
                            <a href="#" commandName="down" commandArgument='<%# Eval("Id") %>' title="下移">↓</a>
                            <br /><ol commandArgument='<%# Eval("Id") %>'>
                            <asp:Repeater ID="SystemLinksRepeater" runat="server">
                                <ItemTemplate>
                                    <li id='<%# string.Format("systemLink_{0}",Eval("Id").ToString()) %>' commandArgument='<%# Eval("Id") %>'>
                                        <span class="site">
                                            [<a href="#" commandName="Delete" commandArgument='<%# Eval("Id") %>'>X</a>] 
                                            <a target="_blank" href='<%# string.Format("{0}?id={1}&url={2}",VirtualPathUtility.ToAbsolute("~/daohang.aspx"),Eval("Id").ToString(),Eval("Url").ToString()) %>'>
                                                <%# Eval("Title") %>
                                            </a>
                                            <a href="#" commandName="up" commandArgument='<%# Eval("Id") %>' title="上移">↑</a>
                                            <a href="#" commandName="down" commandArgument='<%# Eval("Id") %>' title="下移">↓</a>
                                        </span>
                                    </li>
                                </ItemTemplate>
                            </asp:Repeater>
                            </ol>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                    </FooterTemplate>
                </asp:Repeater>
            
            </div>
            <div id="fragment-2" style="line-height:250%;padding:10px">
                <h5><%= UIText.GetSafeText("SiteMenu", "SystemLinks_Category_Title", string.Empty)%></h5>
                <asp:Repeater ID="LinkCategoriesRepeater" runat="server">
                    <HeaderTemplate>
                        <ul id="systemLinkCategoriesContainer" style="list-style-type:none;margin:0px;" class="clearfix">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <li style="float:left;display:block;width:100px;">
                            <input  type="radio" name="systemLinkCategory" <%# Container.ItemIndex==0?"checked=\"checked\"":"" %> commandArgument='<%#  Eval("Id") %>' id='<%# string.Format("LinkCategory_{0}", Eval("Id").ToString()) %>' /><label for='<%# string.Format("LinkCategory_{0}", Eval("Id").ToString()) %>'><%# Eval("Title") %></label>
                        </li>
                    </ItemTemplate>
                    <FooterTemplate>
                        </ul>
                    </FooterTemplate>
                </asp:Repeater>
                <br />
                <label>标题：</label><input type="text" class="niceTxt" id="linkTitleTextBox" /><br />
                <label>地址：</label><input type="text" class="niceTxt" id="linkUrlTextBox" /><br />
                
                <br />
                
                <input type="button" class="niceButton" id="saveSystemLinkButton" value="保存链接" />
            </div>
            <div id="fragment-3">
                <label>分类名称：</label>
                <br />
                <input type="text" class="niceTxt" id="linkCategoryTextBox" />
                <br />
                <br />
                <input type="button" class="niceButton" id="saveSystemLinkCategoryButton" value="保存分类" />
            </div>
        </div>      
        
        
    
</asp:Content>
