﻿<%@ Page Language="C#" MasterPageFile="~/HostAdmin/HostAdminTemplate_Main.Master" AutoEventWireup="true" CodeBehind="SystemTagPosts.aspx.cs" Inherits="EnjooSite.Web.HostAdmin.Frame_Main.SystemTagPosts" Title="Untitled Page" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">    
    <link href='<%= VirtualPathUtility.ToAbsolute("~/Skins/_HostAdmin/SystemTags.css") %>' rel="stylesheet" type="text/css" />
    <script type="text/javascript">
        $(function(e) {
            parent.topFrame.hideAlert();
            $('#tabs>ul').tabs();   
            $("#systemTagRelatePostsContainer a[commandName=delete]").bind("click", deleteSystemTagRelatedPost);
            $("div.pager a[class!=disabled]").bind("click",showLoading);
            $("a[href='SystemTagsList.aspx']").bind("click",showLoading);
        });

        function deleteSystemTagRelatedPost(e) {
            parent.topFrame.displayAlert(null, { message: "", type: "loading", autoHide: false });
            var entryId = $(this).attr("commandArgument");
            var currentTagId = <%= Request.QueryString["TagId"] %>;
            PageMethods.DeleteSystemTagRelatedPost(
                entryId,
                currentTagId,
                function(result, userContext, methodName) {
                    result = eval("(" + result + ")");
                    if( result.type == "success"){
                        $(userContext).parent().remove();
                    };
                    parent.topFrame.displayAlert(null, result);
                },
                function(error, userContext, methodName) {
                    parent.topFrame.displayAlert(null, { message: error.get_message(), type: "error", autoHide: true });
                },
                $(this)
            );
            return false;
        };
        function showLoading(e){
            parent.topFrame.isPostback = false;
            parent.topFrame.displayAlert(null,{message:"",type:"loading",autoHide:false});
        };
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MPContent" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>
    <st:MessagePanel id="Messages" runat="server" />
    <h5>
        <a href="SystemTagsList.aspx">返回</a> | 当前系统标签：<asp:Label ID="SystemTagLabel" runat="server"></asp:Label>
    </h5>
    <br />
    
    <div id="tabs">
        <ul style="margin: 0px;">
            <li class="ui-tabs-nav-item"><a href="#fragment-1">
                <%= UIText.GetSafeText("SiteMenu", "Munu_SystemTagRelatePosts_Text", string.Empty)%></a>
            </li>
            <li class="ui-tabs-nav-item" style="display:none;"><a href="#fragment-2">
                <%= UIText.GetSafeText("SiteMenu", "Munu_AddSystemTags_Text", string.Empty)%></a>
            </li>
        </ul>
        <div id="fragment-1" style="padding: 5px 10px;">
            <br />
            <div class="pager clearfix" style="margin:15px;text-align:right;">
                <div style="float:right;">
                    <st:AspNetPager ID="AspNetPager2" runat="server"  CloneFrom="AspNetPager1"></st:AspNetPager>
                </div>
            </div>
            <asp:Repeater ID="SystemTagPostsRepeater" runat="server">
                <HeaderTemplate>
                    <ul id="systemTagRelatePostsContainer" style="list-style-type:none;margin:0px;padding:0px;">
                </HeaderTemplate>
                <ItemTemplate>
                    <li style="line-height:2em;height:2em;">[ <a href="#" commandName="delete" commandargument='<%# Eval("ID") %>' title="删除当前关联">X</a> ] &nbsp;
                        <a href='<%# Eval("Url") %>'
                        target="_blank">
                        <%# Eval("Title") %>
                    </a></li>
                </ItemTemplate>
                <FooterTemplate>
                    </ul>
                </FooterTemplate>
            </asp:Repeater>
            <div class="pager clearfix" style="margin:15px;text-align:right;">
                <div style="float:right;">
                    <st:AspNetPager ID="AspNetPager1" runat="server" UrlPaging="true" LayoutType="Div"  PageSize="20" OnPageChanged="AspNetPager1_PageChanged"></st:AspNetPager>
                </div>
            </div>
            <br />
        </div>
        <div id="fragment-2" style="padding: 5px 10px;">
        </div>
    </div>
        
</asp:Content>
