﻿<%@ Page Language="C#" MasterPageFile="~/Skins/_System/Common.Master" AutoEventWireup="true" CodeBehind="Register.aspx.cs" Inherits="EnjooSite.Web.Register" Title="Untitled Page" %>

<%@ Register TagPrefix="sub" Namespace="EnjooSite.Web.Controls.Captcha" Assembly="EnjooSite.Web.Controls" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <script type="text/javascript" src="<%= VirtualPathUtility.ToAbsolute("~/Scripts/V.Enjoy/Common.js") %>"></script>
    <script type="text/javascript" src="<%= VirtualPathUtility.ToAbsolute("~/Scripts/V.Enjoy/Register.js") %>"></script>
    <script type="text/javascript">
        var _userNameCID = '<%= UserNameTextBox.ClientID %>';
        var _userEmailCID = '<%= EmailTextBox.ClientID %>';
        var _emailVerifyCID = '<%= EmailVerifyTextBox.ClientID %>';
        var _passwordCID = '<%= PasswordTextBox.ClientID %>';
        var _passwordVerifyCID = '<%= PasswordVerifyTextBox.ClientID %>';        
        var _captchaCName = '<%= captcha.ClientID %>_answer';
        var _captchaCID = '<%= captcha.ClientID %>';
        
    </script>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>
    <div id="registerContainer">
        <fieldset class="wide">
            <legend><asp:Label ID="lblMessage" runat="server"></asp:Label></legend>            
            <div class="form_row">
                <label for='<%= UserNameTextBox.ClientID %>'>
                    <%= UIText.GetSafeText("VSite","Label_ChooseAUserName_Text",string.Empty) %>
                </label>
                <asp:TextBox ID="UserNameTextBox" runat="server" CssClass="register_input"></asp:TextBox>
                <div class="form_note" id="note-username" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages" , "Register_UserName_Note" , string.Empty ) %>
                </div>
            </div>
            <div class="form_row">
                <label for='<%= EmailTextBox.ClientID %>'>
                    <%= UIText.GetSafeText("VSite" , "Label_Email_Text", string.Empty) %>
                </label>
                <asp:TextBox ID="EmailTextBox" runat="server" CssClass="register_input"></asp:TextBox>
                <div class="form_note" id="note-email" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages","Register_Email_Note",string.Empty)  %>
                </div>
            </div>
            <div class="form_row">
                <label for='<%= EmailVerifyTextBox.ClientID %>'>
                    <%= UIText.GetSafeText("VSite" , "Label_EmailVerify_Text", string.Empty) %>
                </label>
                <asp:TextBox ID="EmailVerifyTextBox" runat="server" CssClass="register_input"></asp:TextBox>
                <div class="form_note" id="note-emailverify" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages","Register_EmailVerify_Note",string.Empty)  %>
                </div>
            </div>
            <div class="form_row">
                <label for='<%= PasswordTextBox.ClientID %>'>
                    <%= UIText.GetSafeText("VSite" , "Label_ChoosePassword_Text", string.Empty) %>
                </label>
                <asp:TextBox ID="PasswordTextBox" TextMode="Password" runat="server" CssClass="register_input"></asp:TextBox>
                <div class="form_note" id="note-password" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages","Register_Password_Note",string.Empty)  %>
                </div>
            </div>
            <div class="form_row">
                <label for='<%= PasswordVerifyTextBox.ClientID %>'>
                    <%= UIText.GetSafeText("VSite", "Label_ChoosePasswordVerify_Text", string.Empty)%>
                </label>
                <asp:TextBox ID="PasswordVerifyTextBox" TextMode="Password" runat="server" CssClass="register_input"></asp:TextBox>
                <div class="form_note" id="note-passwordVerify" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages","Register_PasswordVerify_Note",string.Empty)  %>
                </div>
            </div>
            <div class="captcha-container">
                <label for="captcha"></label>
                <div class="captcha-left">                   
                    <sub:EnjooSiteCaptchaControl ID="captcha" runat="server" CssClass="captcha"  NoteText="<%$ Resources:VSite,Captcha_Error %>" ToolTip="<%$ Resources:VSite,Captcha_Error %>"  ErrorMessage="<%$ Resources:VSite,Captcha_Error %>" />            
                </div>
            </div>
            <div class="form_row services_row">                
                <label class="form_checkbox" for="register-terms">
                    <input class="checkbox" id="register-terms" type="checkbox" name="register-terms" />
                    <%= string.Format( UIText.GetSafeText("VSite","Register_TermsServices_Note",string.Empty ) , string.Empty )  %>
                </label>
                <div class="form_note" id="noteServices" style="visibility: hidden">
                    <%= UIText.GetSafeText("VMessages", "Register_Services_Note", string.Empty)%>
                </div>
            </div>
            <div class="hSpace_10"></div>
            <asp:Button ID="SubmitButton" runat="server" CssClass="button submit"  Text="<%$ Resources:VSite, Button_Continue_Text %>" OnClick="SubmitButton_Click" />
        </fieldset>
    </div>
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="PageNavigeContentPlaceHolder" runat="server">
</asp:Content>
