<%@ Control Language="C#" EnableTheming="false"  AutoEventWireup="false" Inherits="EnjooSite.Web.UI.Controls.SilverAlbumViewer" %>
<%@ Import Namespace="EnjooSite.Framework.Format" %>

<%@ Register TagPrefix="uc1" TagName="CategoryList" Src="CategoryList.ascx" %>

<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
    <Scripts>
        <asp:ScriptReference Path="~/Scripts/Blogs/silverAlbumViewHelper.js" />
        <asp:ScriptReference Path="~/Scripts/json.js" />
        <asp:ScriptReference Path="~/common/scripts/swfobject/swfobject_2.1.js" />
        <asp:ScriptReference Path="~/common/scripts/swfobject/ac_runactivecontent.js" />
        <asp:ScriptReference Path="~/Providers/BlogEntryEditor/fckeditor2/fckeditor.js" />
        <asp:ScriptReference Path="~/scripts/blogs/fckeditorhelper.js" />
        <asp:ScriptReference Path="~/Common/Scripts/jquery_lightbox/js/jquery.lightbox.1.3.4.packed.js" />
    </Scripts>
</asp:ScriptManagerProxy>

<div id="journalListContainer" class="grid_8 content_container journal_eintrag">
    <div class="inner_box" style="padding:10px 0;">
        <div class="simply_box">
            <h5 class="dashed_bottom_1"><asp:Literal id="GalleryTitle" runat="server" /></h5>
            <div id="silverAlbumContainer"></div>
        </div>
        <div class="hSpace_10"></div>
        <div class="hSpace_10"></div>
        
        <div class="simply_box">
            <h5 class="dashed_bottom_1">ͼ</h5>
            <ul class="h_list gallery_thumb_list clearfix">
            <asp:Repeater ID="ThumbRepeater" runat="server">
                <ItemTemplate>
                    <li>
                        <a class="lightbox" rel="lightbox-silverAlbum" href='<%# string.Format("/Thunmbnails/{1}x{2}/{0}.ashx", ((SilverImage)Container.DataItem).NetFileId , 640,480)   %>' title='<%# ((SilverImage)Container.DataItem).Title %>'>
                            <span style='background-image:url(<%#  string.Format("/Thunmbnails/{1}x{2}/{0}.ashx", ((SilverImage)Container.DataItem).NetFileId , 160,120) %>);'><%# ((SilverImage)Container.DataItem).Title%></span>
                        </a>
                    </li>
                </ItemTemplate>
            </asp:Repeater>
            </ul>
        </div>
        
        <% if (Config.CurrentBlog.CommentsEnabled && SilverAlbum.AllowComments)
           {  %>
           <div class="hSpace_10"></div>
           <div class="simply_box">
               <h5 class="dashed_bottom_1"><span></span></h5>
               <ul id="commentsContainer" class="v_list">
                <asp:Repeater ID="CommentsRepeater" runat="server">
                    <ItemTemplate>
                        <li class='<%# (((FeedbackItem)Container.DataItem).IsBlogAuthor)?"author":string.Empty %>' commandArgument='<%# ((FeedbackItem)Container.DataItem).Id %>'>                        
                            <table class="comment_item simply_table ">
                                <tr>
                                    <td class="enjooTd01" valign="top">
                                        <img class="small_logo" src='<%# BlogInfo.GetLogoUrl( ((FeedbackItem)Container.DataItem).CommenterApplication , ((FeedbackItem)Container.DataItem).CommenterID ) %>' alt='<%# ((FeedbackItem)Container.DataItem).CommenterAuthor %>' />
                                    </td>
                                    <td class="enjooTd02" valign="top">
                                        <ul class="commentHead h_list clearfix">
                                            <li>
                                                <a name='<%# string.Format("SilverAlbumComments_{0}",((FeedbackItem)Container.DataItem).Id) %>'>#<%# Container.ItemIndex + 1 %>¥</a>                                            
                                            </li>
                                            <li class="separator">|</li>
                                            <li>
                                                <%# UIText.NiceDateString(((FeedbackItem)Container.DataItem).DateCreated)%>
                                            </li>
                                            <li  class="separator">|</li>
                                            <li>
                                                <a href='<%# ((FeedbackItem)Container.DataItem).SourceUrl.ToString() %>'><%# ((FeedbackItem)Container.DataItem).CommenterAuthor %></a>
                                            </li>
                                            <li style="float: right;">
                                                <%# (((FeedbackItem)Container.DataItem).IsPoster || SecurityHelper.IsAdmin)?string.Format("<a href=\"#\" commandName=\"deleteComment\" commandArgument=\"{0}\">{1}</a>",((FeedbackItem)Container.DataItem).Id,UIText.GetSafeText("VSite", "Button_Delete_Text", string.Empty)):string.Empty %>
                                            </li>
                                        </ul>
                                        <div class="comment_content">
                                            <%# ((FeedbackItem)Container.DataItem).Body %>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </li>
                    </ItemTemplate>
                </asp:Repeater>                
               </ul>               
               <% if (Config.CurrentLoginer != null)
                  {%>
                   <ul class="v_list enjoo_box_content">
                        <li>
                            <input type="text" id="commentsTitleTextBox" size="40" maxlength="128" class="simply_text"  style="width:342px;"/>                    
                        </li>
                        <li>
                            <div id="commentsBodyContainer" style="width:350px;"></div>
                        </li>
                        <li>
                            <input id="saveCommentsButton" type="button" class="submit_button" value="ȷ" />
                        </li>
                    </ul>
                   <script type="text/javascript">
                        $(function(e) {
                            $("#commentsTitleTextBox").val('<%= string.Format("RE:{0}" , SilverAlbum.Title) %>');
                            var fckeditorID = '<%= string.Format("SilverAlbumComments_{0}_richTextEditor",SilverAlbum.SilverAlbumId) %>';
                            var basePath = '<%= HttpHelper.ExpandTildePath("~/Providers/BlogEntryEditor/fckeditor2/") %>';
                            var toolbarSet = "Mini";
                            initFCKeditor(fckeditorID, basePath, toolbarSet, "commentsBodyContainer");
                            $("#saveCommentsButton").bind("click", { sender: $("#saveCommentsButton"), titleTextBox: $("#commentsTitleTextBox"), fckeditorID: fckeditorID }, saveSilverAlbumComments);
                        });
                    </script>
                <% }else{ %>
                    <label>۽ԻԱ</label>
                <% } %>
            </div>
           <div class="hSpace_10"></div>
        <% } %>
        
    </div>
</div>


<div class="grid_4 content_sidebar">
    <div class="inner_box">
    
        <div class="enjoo_ad_s1">
            <%= Config.SystemSettings.AD_PostPage %>
        </div>    
        <div class="hSpace_10"></div>
        
        <uc1:CategoryList ID="CategoryList1" runat="server" />
        <div class="hSpace_10"></div>
        
    </div>
</div>

<div class="clear"></div>

<script type="text/javascript">
    var __currentSilverAlbumId = <%= UrlFormats.GetPostIDFromUrl(Request.Path) %>;
</script>

