<%@ Control Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.ThemeManager" %>
<%@ Import Namespace="EnjooSite.Framework.Security" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>

<div class="grid_9">
    <div id="themeCategoriesContainer" class="inner_box border_right_1">
    
        <div class="enjoo_portal">
        
            <asp:Repeater ID="CategoriesRepeater" runat="server" OnItemDataBound="CategoriesRepeater_ItemDataBound">
                <ItemTemplate>
                    <h5><%# Eval("Title") %></h5>
                    <a name='<%# string.Format("themeCategory_{0}",Eval("Name")) %>'></a>
                    <asp:Repeater ID="ThemesRepeater" runat="server">
                        <HeaderTemplate>
                            <ul class="enjoo_portal_container h_list clearfix themes_container">
                        </HeaderTemplate>
                        <ItemTemplate>
                            <li <%# string.Equals(CurrentBlog.Skin.ThemeName,Eval("TemplateFolder").ToString(), StringComparison.InvariantCultureIgnoreCase)==true?" class=\"current\" ":string.Empty  %>>
                                <a class="theme_thumb_box"  href="#" title='<%# Eval("Name") %>' commandName="updateTheme" commandArgument='<%# Eval("TemplateFolder") %>'>
                                    <span <%# GetBackgroundImage(Eval("TemplateFolder")) %>><%# Eval("Name") %></span>
                                </a>
                            </li>
                        </ItemTemplate>
                        <FooterTemplate>
                            </ul>
                        </FooterTemplate>
                    </asp:Repeater>
                </ItemTemplate>
            </asp:Repeater>
                        
            <div class="hSpace_10"></div>
            <div class="hSpace_10"></div>
            
            <input type="button" class="buttonSubmit" id="saveSpaceThemeButton" disabled="disabled" commandName="updateTheme" commandArgument='<%= CurrentBlog.Skin.ThemeName %>' value='<%= UIText.GetSafeText("VSite","Button_Yes_Text",string.Empty) %>' />
            <input type="button" class="buttonSubmit" id="canelButton" value='<%= UIText.GetSafeText("VSite","Button_Cancel_Text",string.Empty) %>' />
            
            <div class="hSpace_10"></div>
            <div class="hSpace_10"></div>
        </div>
    </div>
</div>
<div class="grid_3 sidebar_container">
    <div class="inner_box">
        <h5><span></span></h5>
        <ul class="hr_menu">
            <asp:Repeater ID="ThemeCagegoriesRepeater" runat="server">
                <ItemTemplate>
                    <li class='menu_item  <%# Container.ItemIndex==0?"\"current\"":string.Empty %>'>
                        <a href='<%# string.Format("#themeCategory_{0}",Eval("Name")) %>' commandArgument='<%# Eval("Name") %>' title='<%# Eval("Title") %>'><span><%# Eval("Title") %></span></a>
                    </li>
                </ItemTemplate>
            </asp:Repeater>                    
        </ul>    
        <div class="hSpace_10"></div>
    </div>
</div>
<div class="clear"></div>