<%@ Control Language="C#" AutoEventWireup="true" Inherits="EnjooSite.Web.UI.Controls.AggRecentPosts" %>
<%@ Import Namespace="EnjooSite.Framework" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:repeater id="RecentPosts" runat="server" onitemcreated="RecentPosts_ItemCreated">
    <HeaderTemplate>
	        <ul id='<%= this.ClientID %>' class="enjoosite_avatar_news_list clearfix">
    </HeaderTemplate>
	<ItemTemplate>
                <li class="enjoosite_avatar_news_list_item">
                    <img class="user_avatar" src="<%# BlogInfo.GetSmallLogoUrl(Eval("Application").ToString(), Convert.ToInt32(Eval("BlogID").ToString())) %>"  alt='<%# Eval("Author")%>' />
                    <div class="enjoosite_avatar_news_list_title">
                    [<a href='<%# BlogInfo.GetRootUrl(Eval("Application").ToString()) %>'><%# Eval("Author")%></a>]
                    <a href='<%# GetEntryUrl(DataBinder.Eval(Container.DataItem,"host").ToString(),DataBinder.Eval(Container.DataItem,"Application").ToString(), DataBinder.Eval(Container.DataItem,"EntryName").ToString(), (DateTime)DataBinder.Eval(Container.DataItem,"DateAdded")) %>' title='<%# Eval("Title") %>'><%# Eval("Title") %></a>
                    </div>
                    <small><%# UIText.NiceDateString(DateTime.Parse(Eval("DateAdded").ToString()))%></small>
                    
                    <div style='display:none;' >
                        <asp:Image ID="PostLogoImage" runat="server" ImageAlign="Left" BorderWidth="1" Visible="false" />
                        <div>
                            <asp:Literal ID="PostBodyLiteral" runat="server"></asp:Literal>
                        </div>
                    </div>       
                </li>
	</ItemTemplate>
	<FooterTemplate>
        </ul>
	</FooterTemplate>
</asp:repeater>

