<%@ Control Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.Site.ArticlesList" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<asp:Repeater ID="ArticlesRepeater" runat="server" OnItemCreated="PostCreated">
    <HeaderTemplate>
	    <ul id='<%= string.Format("recentBlogTopPost_{0}", this.ClientID) %>' class="enjoosite_avatar_news_list clearfix">
    </HeaderTemplate>
    <ItemTemplate>
        <li class="enjoosite_avatar_news_list_item">
            <img class="user_avatar" src='<%# BlogInfo.GetSmallLogoUrl( Eval("Subfolder").ToString(), ((Entry)Container.DataItem).BlogId) %>' alt='<%# Eval("Author")%>' />
            <div class="enjoosite_avatar_news_list_title">
                [<a href='<%# BlogInfo.GetRootUrl(Eval("Subfolder").ToString()) %>'><%# Eval("Author")%></a>]
                <a href='<%# Eval("Url") %>' title='<%# Eval("Title") %>'><%# Eval("Title") %></a>
            </div>
            <small><%# UIText.NiceDateString(DateTime.Parse(Eval("DateSyndicated").ToString()))%></small>
            <div style="display:none;" >
                <asp:Image ID="PostLogoImage" runat="server" ImageAlign="Right" BorderWidth="1" Visible="false" />
                <asp:Literal ID="PostText" runat="server" Visible='<%# Container.ItemIndex==0?true:false %>' />
            </div>
        </li>
    </ItemTemplate>
	<FooterTemplate>
        </ul>
	</FooterTemplate>
</asp:Repeater>