<%@ Control Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.SystemWebPage.ClientTemplates.WidgetData"   %>
<%@ Import Namespace="EnjooSite.Extensibility.Interfaces" %>
<%@ Import Namespace="Newtonsoft.Json" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="EnjooSite.Framework.Text" %>

<script type="text/C#" runat="server">
    public string GetBlogArticles()
    {
        int categoryId = NullValue.NullInt32;
        if (StringHelper.IsNumeric(Key))
        {
            categoryId = Convert.ToInt32(Key);
        }
        SystemArticleCategory articleCategory = SystemArticles.GetCategory(categoryId);
        
        IPagedCollection<Entry> pagedArticles = Entries.GetPagedChannelEntries(PostType.BlogPost, categoryId , 1 , ListCount , LinkConfig.IsActive );
        
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonTextWriter(stringWriter);
        jsonWriter.WriteStartObject();
        jsonWriter.WritePropertyName("maxItems");
        jsonWriter.WriteValue( pagedArticles.MaxItems);
        jsonWriter.WritePropertyName("key");
        jsonWriter.WriteValue( Key);
        if (articleCategory != null)
        {
            jsonWriter.WritePropertyName("categoryTitle");
            jsonWriter.WriteValue(articleCategory.Title);

            jsonWriter.WritePropertyName("categoryUrl");
            jsonWriter.WriteValue(articleCategory.Url);
        }
        jsonWriter.WritePropertyName("articles");
        jsonWriter.WriteStartArray();

        foreach (Entry item in pagedArticles)
        {
            jsonWriter.WriteStartObject();
            jsonWriter.WritePropertyName("id");
            jsonWriter.WriteValue(item.Id);
            jsonWriter.WritePropertyName("title");
            jsonWriter.WriteValue(item.Title);
            jsonWriter.WritePropertyName("url");
            jsonWriter.WriteValue(item.Url);
            jsonWriter.WritePropertyName("isTop");
            jsonWriter.WriteValue(item.IsChannelTop);
            jsonWriter.WriteEndObject();
        }
        jsonWriter.WriteEndArray();
        jsonWriter.WriteEndObject();
        jsonWriter.Flush();
        
        return stringWriter.GetStringBuilder().ToString();
    }
</script>
<%= GetBlogArticles()%>