<%@ Control Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.SystemWebPage.ClientTemplates.WidgetData"   %>
<%@ Import Namespace="EnjooSite.Extensibility.Interfaces" %>
<%@ Import Namespace="Newtonsoft.Json" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="EnjooSite.Framework.Text" %>

<script type="text/C#" runat="server">
    public string GetSystemArticles()
    {
        int categoryId = NullValue.NullInt32;
        if (StringHelper.IsNumeric(Key))
        {
            categoryId = Convert.ToInt32(Key);
        }
        SystemArticleCategory articleCategory = SystemArticles.GetCategory(categoryId);
        
        IPagedCollection<SystemArticle> pagedArticles = SystemArticles.GetPaged(Convert.ToInt32(Key), 1, ListCount , ArticleConfig.None );
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonTextWriter(stringWriter);
        jsonWriter.WriteStartObject();
        jsonWriter.WritePropertyName("maxItems");
        jsonWriter.WriteValue( pagedArticles.MaxItems);
        jsonWriter.WritePropertyName("key");
        jsonWriter.WriteValue( Key);
        if (articleCategory != null)
        {
            jsonWriter.WritePropertyName("categoryTitle");
            jsonWriter.WriteValue(articleCategory.Title);

            jsonWriter.WritePropertyName("categoryUrl");
            jsonWriter.WriteValue(articleCategory.Url);
        }
        jsonWriter.WritePropertyName("articles");
        jsonWriter.WriteStartArray();

        foreach (SystemArticle item in pagedArticles)
        {
            jsonWriter.WriteStartObject();
            jsonWriter.WritePropertyName("id");
            jsonWriter.WriteValue(item.Id);
            jsonWriter.WritePropertyName("title");
            jsonWriter.WriteValue(item.Title);
            jsonWriter.WritePropertyName("url");
            jsonWriter.WriteValue(item.Url);
            jsonWriter.WritePropertyName("categoryTitle");
            jsonWriter.WriteValue(item.CategoryTitle);
            jsonWriter.WritePropertyName("categoryFriendName");
            jsonWriter.WriteValue(item.CategoryFriendName);
            jsonWriter.WritePropertyName("isTop");
            jsonWriter.WriteValue(item.IsTop);
            jsonWriter.WriteEndObject();
        }
        jsonWriter.WriteEndArray();
        jsonWriter.WriteEndObject();
        jsonWriter.Flush();
        
        return stringWriter.GetStringBuilder().ToString();
    }
</script>
<%= GetSystemArticles() %>