<%@ Control Language="C#" EnableTheming="false" Inherits="EnjooSite.Web.UI.Controls.Site.SiteLayoutEdit" %>
<%@ Register TagName="SystemTagsCloud" TagPrefix="asp" Src="SystemTagsCloud.ascx" %>
<%@ Register TagPrefix="uc1" TagName="ChannelsCategoryList" Src="~/Skins/_SystemSite/Common/Controls/ChannelsCategoryList.ascx" %>
<%@ Register TagPrefix="uc1" TagName="SiteMenu" Src="SiteMenu.ascx" %>
<%@ Register TagPrefix="uc1" TagName="SiteHeader" Src="SiteHeader_EditMode.ascx" %>

<%@ Register TagName="Footer" TagPrefix="asp" Src="Footer.ascx" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>

<% if (!HttpContext.Current.User.IsInRole("HostAdmins")) { HttpContext.Current.Response.Redirect("~/"); } %>
<asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server"></asp:ScriptManagerProxy>

<div id="siteWrapper">

    <div id="header" class="clearfix">
        <div class="container_12">
            <uc1:SiteHeader id="SiteHeader1" runat="server" />
        </div>
    </div>
            
    <div id="main" class="clearfix">
        <div class="container_12">  
            <div id="layoutContainer">
                <asp:PlaceHolder ID="LayoutPlaceHolder" runat="server"></asp:PlaceHolder>        
                <div class="clear"></div>
             </div>   
        </div>
    </div>
    
    <div id="layoutSetBox" class="container_12" style="text-align:left;">
        <div id="layoutSetSidebar">
            <ul class="niceList clearfix">
                <li commandArgument="pageTheme" commandName="layoutEdit">
                    <span><%= UIText.GetSafeText("VSite", "Label_PageTheme_Text", string.Empty)%></span>
                </li>
                <li commandArgument="pageLayout" commandName="layoutEdit">
                    <span><%= UIText.GetSafeText("VSite", "Label_PageLayout_Text", string.Empty)%></span>
                </li>
                <li class="separator"></li>
                <li commandArgument="systemWidgets" commandName="layoutEdit">
                    <span><%= UIText.GetSafeText("SiteMenu", "Layout_WidgetsMenu_Text", string.Empty)%></span>
                </li>
                <li commandArgument="systemTags" commandName="addWidget">
                    <span><%= UIText.GetSafeText("SiteMenu", "Layout_AddTagModule_Text", string.Empty)%></span>
                </li>
                <li commandArgument="systemChannels" commandName="addWidget" style="display:none;">
                    <span><%= UIText.GetSafeText("SiteMenu", "Layout_AddChannelModule_Text", string.Empty)%></span>
                </li>
                <li class="separator"></li>
                <li commandArgument="rssSubscription" commandName="layoutEdit">
                    <span><%= UIText.GetSafeText("SiteMenu", "Layout_RssWidget_Text", string.Empty)%></span>
                </li>
                <li class="separator"></li>
            </ul>
        </div>
        <div id="layoutSetContent">
            <ul class="niceList clearfix" style="padding:0px;">
                <li class="sidebar">
                    <ul class="niceList" commandArgument="layoutSetSubMenu">
                    </ul>
                </li>
                <li class="body">
                    <h5 id="currentActionTitle"></h5>
                    <div class="content" commandArgument="layoutSetContent"></div>
                </li>
            </ul>
        </div>
    </div>
    
    <div id="footer">
        <div class="container_12">
            <asp:Footer ID="Footer1" runat="server" />
        </div>
    </div>
       
    <div class="clear"></div>
    
</div>
