<%@ Page Language="C#"   MasterPageFile="~/Skins/_System/Common.Master"  Codebehind="login.aspx.cs" AutoEventWireup="True" Inherits="EnjooSite.Web.Pages.login" %>
<%@ Register Assembly="DotNetOpenId" Namespace="DotNetOpenId.RelyingParty" TagPrefix="cc1" %>  
<%@ Register TagPrefix="sub" Namespace="EnjooSite.Web.Controls.Captcha" Assembly="EnjooSite.Web.Controls" %>
<%@ Import Namespace="EnjooSite.Web.UI" %>
<%@ Import Namespace="EnjooSite.Framework.Text" %>

<asp:Content ContentPlaceHolderID="head" ID="Content1" runat="server">
    <script type="text/javascript">
        var _loginButtonId = '<%= btnLogin.ClientID %>';
        var _userNameTextBoxId = '<%= tbUserName.ClientID %>';
        var _passwordTextBoxId = '<%= tbPassword.ClientID %>';
        var _rememberCheckBoxId = '<%= chkRememberMe.ClientID %>';
        <% 
            string returnUrl = HttpContext.Current.Request.QueryString["ReturnURL"]; 
            if (returnUrl != null && StringHelper.Contains(returnUrl, "HostAdmin", StringComparison.InvariantCultureIgnoreCase))
            {
        %>
        var _isHostAdmin = true ;
        <% }
        else
        { %>
        var _isHostAdmin = false ;
        <%} %>
    </script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    <asp:ScriptManagerProxy ID="ScriptManagerProxy1" runat="server">
        <Scripts>
            <asp:ScriptReference Path="~/Scripts/V.Enjoy/Login.js" />
        </Scripts>
        <Services>
            <asp:ServiceReference Path="~/WebServices/AsynLogin.asmx" />
        </Services>
    </asp:ScriptManagerProxy>
    
    <div id="registerContainer">
        <fieldset class="wide">
            <div class="error" id="alertBox" style="margin:10px 0;">
                <asp:Literal EnableViewState="false" ID="Message" runat="server" />
            </div>
            <div class="form_row">
                <label for="<%= tbUserName.ClientID %>">
                    <%= UIText.GetSafeText("VSite","Label_UserName_Text",string.Empty ) %>
                </label>
                <asp:TextBox ID="tbUserName" runat="server" CssClass="register_input" TabIndex="1" />
            </div>
            <div class="form_row">
                <label for="<%= tbPassword.ClientID %>">
                    <%= UIText.GetSafeText("VSite","Label_Password_Text",string.Empty ) %>
                </label>
                <asp:TextBox ID="tbPassword" TextMode="Password" runat="server" CssClass="register_input" TabIndex="2" />
            </div>
            <div class="form_row">
                <asp:CheckBox ID="chkRememberMe" runat="server" Text="<%$ Resources:VSite,Label_RememberMe_Text %>" TextAlign="left" TabIndex="3" CssClass="rememberMe" />
            </div>
            <div id="loading"></div>
            <div class="form_row" style="margin:10px 0;">  
                <asp:Button ID="btnLogin" runat="server" Text="<%$ Resources:VSite,Button_Login_Text %>" CssClass="button" TabIndex="4" />
                <br />
                <p class="forgotPassword" style="display:none;">
                    <a href="ForgotPassword.aspx" title="Click to reset your password" tabindex="5">
                        <%= UIText.GetSafeText("VSite","Link_ForgotYourPassword_Text", string.Empty)  %>
                    </a>
                </p><br />
                <br />
            </div>
            <div class="form_row" style="display:none;">
            <fieldset>
                <legend>Sign In with OpenID</legend>
                <div class="form_row">
                
                    <cc1:OpenIdLogin ID="btnOpenIdLogin" CssClass="openidLogin" runat="server" LabelText=""
                    RequestEmail="Require" RequestNickname="Request" RegisterVisible="false" RememberMeVisible="True"
                    PolicyUrl="~/PrivacyPolicy.aspx" TabIndex="6" OnLoggedIn="btnOpenIdLogin_LoggedIn"
                    ButtonText="Login" Text="http://" />
                </div>
            </fieldset>
            </div>
        </fieldset>
    </div>
    
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="PageNavigeContentPlaceHolder" runat="server">
    <div class="selector clearfix"  style="display:none;">
        <div class="navbar">
            <ul class="treePath clearfix">
                <li class="separator">
                    <%= UIText.GetSafeText("VSite","Label_Location_Text",string.Empty ) %>
                </li>
                <li class="current">
                    <%= UIText.GetSafeText("VSite","Label_SignIn_Text" , string.Empty ) %>
                </li>
            </ul>
        </div>
    </div>
</asp:Content>