﻿<%@ Page Language="C#" MasterPageFile="Blog.master" AutoEventWireup="true" CodeBehind="ArticleList.aspx.cs" Inherits="Ruiao.WebSite.Blog.ArticleList" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="cc1" %>
<asp:Content ID="MyHead" ContentPlaceHolderID="cphHead" Runat="Server">
    <script src="<%=AppUrl %>/Common/Script/Common.js" type="text/javascript"></script>
    <link href="<%=AppUrl %>/SySkins/<%=Config["SySkin"] %>/Page_Channel.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="MyContent" ContentPlaceHolderID="cphMain" Runat="Server">
    <div id="ContentContainer">
    <form id='ArticleList_MainForm' runat="server">
        <div id="MainContent">
            <div id="Top"></div>
            <div id="MyInfo">
                <div id="Channel_Info">
                <div id="Name">日志检索结果<%=KeywordNote%></div>
                </div>
            </div>
            <div id="ArticleList" class="ItemContainer">
            <asp:Repeater ID="rpArticleList" runat="server" OnItemCreated="rpArticleList_ItemCreated" EnableViewState="false">
            <ItemTemplate>
                <div class="Item">
                    <div class="Top">
                        <div class="Left"></div>
                        <div class="Body_Limit" onclick="ContentBodyShow(this,'Post_<%# DataBinder.Eval(Container, "ItemIndex") %>')"></div>
                        <h1 class="Title"><a class="ContentTitleLink" href="<%# MyBloggerUrl %>/<%# PostFile %>"><%# Cnlamar.DataType.TextCheck.HtmlClean(DataBinder.Eval(Container, "DataItem.Title").ToString()) %></a></h1>
                        <div class="Right"></div>
                    </div>
                    <div id="Post_<%# DataBinder.Eval(Container, "ItemIndex") %>">
                        <div class="Item_Body"><%# PostBody %><%if(ShowExcerpt){%><a class="ReadFullArticle" href="<%# MyBloggerUrl %>/<%# PostFile %>"><span>阅读全文</span></a><%}%></div>
                        <div class="Item_OtherInfo"><%# TagHtml%></div>
                        <div class="Item_Bottom">
                            <div class="Left"></div>
                            <div class="Body">
                            Posted @<%#PostTime.ToString(Ruiao.Blog.Common.Dictionary.DateFormat.DefaultValue) %>  <%# DataBinder.Eval(Container, "DataItem.AuthorName") %> | 阅读(<%# DataBinder.Eval(Container, "DataItem.ViewCount") %>) | <a href="<%# MyBloggerUrl %>/<%# PostFile %>#CommentTop">评论(<%# DataBinder.Eval(Container, "DataItem.CommentCount")%>)</a>
                            </div>
                            <div class="Right"></div>
                        </div>
                    </div>
                </div>
            </ItemTemplate>            
            </asp:Repeater>
            </div>
            <cc1:aspnetpager id="Pager" runat="server" AlwaysShow="True" UrlPaging="True"></cc1:aspnetpager>
            <div id="Bottom"></div>
        </div>
    </form>
    </div>
</asp:Content>

