﻿<%@ Page Language="C#" MasterPageFile="../BloggerAdmin.master" AutoEventWireup="true" CodeBehind="AlbumManage.aspx.cs" Inherits="Y10.WebSite.Blog.Blogger.Admin.Album.AlbumManage" %>
<%@ Register Assembly="System.Web.Extensions" Namespace="System.Web.UI" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="phHead" runat="server">
<link href="<%=AppUrl %>/Blogger/Admin/Album/Images/Style/Album.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphMainAdmin" runat="server">
<form id="MainForm" runat="server">
<!--Ajax脚本管理器-->
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
<!--修改Ajax的initialAction-->
<script type="text/javascript">
Sys.Application.add_load(function()
{
    var form = Sys.WebForms.PageRequestManager.getInstance()._form;
    var href = window.location.href;
    form._initialAction = form.action = href;
});
</script>
<!--Ajax进度显示器-->
<asp:UpdateProgress ID="UpdateProgress1" runat="server">
<ProgressTemplate>
<div style="border: 1px solid #DCBE6E;background: #FFFFBF;padding: 5px; position:absolute; left:5px; bottom:5px;">任务处理中,请稍候...</div>
</ProgressTemplate>
</asp:UpdateProgress>

<div id="ContentTitle"><%=MyTitle %></div>
<div id="ContentBody">

    <div id="AlbumAllPage_Nav" class="BrokenLineBox">
    <div class="LeftFloatBox"><a href="AlbumManage.aspx">我的相册</a></div>
    <div class="RightFloatBox">
    <span>空间共<%=ViewState["UploadMaxSize"] %>M，已用<%=((decimal)Member.UploadSize / 1024).ToString(".##")%>M</span>
    <span><img alt="复制相册地址" id="icon_copyAddress" onclick="copyUrl('<%=MyBloggerUrl%>/Album/Default<%=ExtensionName %>');" src="/Blogger/Admin/Album/Images/icon_copyAddress.gif" /></span>
    </div>
    </div>
    
    <div class="FullWidthBox">
    <input type="button" onclick="location='Shoot<%=ExtensionName %>'" value="拍摄相片" class="LinkButton" />
    <input type="button" onclick="location='PhotoAdd<%=ExtensionName %>'" value="上传相片" class="LinkButton" />
    <input type="button" onclick="location='AlbumAdd<%=ExtensionName %>'" value="创建新相册" class="LinkButton" />
    </div>

    <asp:UpdatePanel ID="AlbumListUpdatePanel" runat="server">
    <ContentTemplate>
    <ul id="AlbumList">
    <asp:Repeater ID="rpAlbum" runat="server" OnItemCreated="rpAlbum_ItemCreated" OnItemCommand="rpAlbum_UpdateCommand">
    <ItemTemplate>
    <li class="AlbumItem">
    <div class="AlbumItem_Top"><asp:Label ID="lbAlbumID" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.ID")%>' Visible="false"></asp:Label></div>
    <div class="AlbumItem_Body">
    <div class="AlbumItem_Title">
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
            <div id="Title_View_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="ViewPanel" onclick="Hide('Title_View_<%# DataBinder.Eval(Container, "ItemIndex") %>');Hide('Title_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>');" title="单击可修改相册标题"><%# DataBinder.Eval(Container, "DataItem.Title")%></div>
            <div id="Title_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="EditPanel" style="display:none; text-align:center;">
            <div class="EditPanel_Input"><asp:TextBox ID="tbTitle" runat="server" style="width:50px;" Text='<%# DataBinder.Eval(Container, "DataItem.Title")%>'></asp:TextBox></div>
            <div class="EditPanel_Button">
            <asp:Button ID="btUpdateTitle" runat="server" CssClass="btnSubmit02" CommandName="rpAlbum_UpdateCommand" CommandArgument="UpdateTitle" /><input id="btCancelEditTitle" type="button" class="btnCancel02" onclick="Hide('Title_View_<%# DataBinder.Eval(Container, "ItemIndex") %>');Hide('Title_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>');" />
            </div>
            </div>
        </div>
        </div>
    </div>
    <h2 class="AlbumItem_Channel">频道：<%#ChannelName%></h2>
    <div class="AlbumItem_Cover"><table><tr><td><a href="PhotoManage.aspx?AlbumID=<%# DataBinder.Eval(Container, "DataItem.ID")%>"><img alt="<%# DataBinder.Eval(Container, "DataItem.Title")%>" src="<%# CoverPhoto %>" /></a></td></tr></table></div>
    <div class="AlbumItem_Description">
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
            <div id="Description_View_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="ViewPanel" onclick="Hide('Description_View_<%# DataBinder.Eval(Container, "ItemIndex") %>');Hide('Description_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>');" title="单击可修改相片说明"><%#AlbumDescription%></div>
            <div id="Description_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="EditPanel" style="display:none; text-align:center;">
            <div class="EditPanel_Input"><asp:TextBox ID="tbDescription" runat="server" TextMode="MultiLine" style="width:80px; height:30px;overflow:hidden" Text='<%# DataBinder.Eval(Container, "DataItem.Description")%>'></asp:TextBox></div>
            <div class="EditPanel_Button">
            <asp:Button ID="btUpdateDescription" runat="server" CssClass="btnSubmit02" CommandName="rpAlbum_UpdateCommand" CommandArgument="UpdateDescription" /><input id="btCancelEditDescription" type="button" class="btnCancel02" onclick="Hide('Description_View_<%# DataBinder.Eval(Container, "ItemIndex") %>');Hide('Description_Edit_<%# DataBinder.Eval(Container, "ItemIndex") %>');" />
            </div>
            </div>
        </div>
        </div>
    </div>
    <div class="AlbumItem_OtherInfo">
    <span class="AlbumItem_PhotoNum"><%#PhotoNum %>张</span>
    <span class="AlbumItem_ViewStatus"><%#ViewStatusIcon %></span>
    <span class="AlbumItem_Edit"><a href="AlbumEdit.aspx?AlbumID=<%# DataBinder.Eval(Container, "DataItem.ID")%>"><img alt="修改相册[<%# DataBinder.Eval(Container, "DataItem.Title")%>]的属性" src="<%=AppUrl %>/Blogger/Admin/Album/Images/AlbumModify.gif" style="border:0px;" /></a></span>
    <span class="AlbumItem_Delete"><asp:ImageButton ID="imgbtnAlbumDelete" runat="server" ImageUrl="/Blogger/Admin/Album/Images/AlbumDelete.gif" alt="删除该相册以及里面的所有相片" OnClientClick="if(!confirm('您确定真的要删除该相册以及下面的所有相片吗?')){return false;}" CommandName="rpAlbum_UpdateCommand" CommandArgument="DeleteAlbum" /></span>
    </div>
    </div>
    <div class="AlbumItem_Bottom"></div>
    </li>
    </ItemTemplate>
    <SeparatorTemplate><li class="AlbumItem_Separator"></li></SeparatorTemplate>
    </asp:Repeater>
    </ul>
    </ContentTemplate>
    </asp:UpdatePanel>

</div>
</form>
</asp:Content>