﻿<%@ Page Language="C#" MasterPageFile="../BloggerAdmin.master" AutoEventWireup="true" CodeBehind="PhotoAdd.aspx.cs" Inherits="Y10.WebSite.Blog.Blogger.Admin.Album.PhotoAdd" EnableViewState="true" %>
<asp:Content ID="Content1" ContentPlaceHolderID="phHead" runat="server" EnableViewState="false">
<link href="<%=AppUrl %>/Blogger/Admin/Album/Images/Style/Album.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphMainAdmin" runat="server" EnableViewState="true">
<form id="MainForm" runat="server">
<div id="ContentTitle"><%=MyTitle %></div>
<div id="ContentBody">

<asp:Panel ID="plAlbumSelect" runat="server" EnableViewState="true">
    <!--导航!-->
    <div id="AlbumAllPage_Nav" class="BrokenLineBox">
    <div class="LeftFloatBox"><a href="AlbumManage.aspx">我的相册</a> \ 选择要上传相片的相册</div>
    </div>
    
    <!--已有相册选择!-->
    <ul id="AlbumList">
    <asp:Repeater ID="rpAlbum" runat="server" OnItemCreated="rpAlbum_ItemCreated" EnableViewState="true">
    <ItemTemplate>
    <li class="AlbumItem">
    <div class="AlbumItem_Top"><asp:Label ID="lbAlbumID" runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.ID")%>' Visible="false"></asp:Label></div>
    <div class="AlbumItem_Body">
    <div class="AlbumItem_Title"><%# DataBinder.Eval(Container, "DataItem.Title")%></div>
    <h2 class="AlbumItem_Channel">频道：<%#ChannelName%></h2>
    <div class="AlbumItem_Cover"><table><tr><td><a href="PhotoAdd.aspx?AlbumID=<%# DataBinder.Eval(Container, "DataItem.ID")%>"><img alt="<%# DataBinder.Eval(Container, "DataItem.Title")%>" src="<%# CoverPhoto %>" /></a></td></tr></table></div>
    <div class="AlbumItem_Description"><%# DataBinder.Eval(Container, "DataItem.Description")%></div>
    <div class="AlbumItem_OtherInfo">
    <span class="AlbumItem_PhotoNum"><%#PhotoNum %>张</span>
    <span class="AlbumItem_ViewStatus"><%#ViewStatusIcon %></span>
    </div>
    </div>
    <div class="AlbumItem_Bottom"></div>
    </li>
    </ItemTemplate>
    <SeparatorTemplate><li class="AlbumItem_Separator"></li></SeparatorTemplate>
    </asp:Repeater>
    </ul>
    
    <!--建立新相册!-->
    <table id="AlbumAdd" class="MainContentTable" cellpadding="3" cellspacing="1">
        <tr class="MainContentList_ItemTR">
	        <td style="width:26%;text-align:right;">相册名称：</td>
	        <td style="width:74%"><asp:TextBox ID="tbTitle" runat="server" MaxLength="20" EnableViewState="true"></asp:TextBox><span class="NotesText"></span></td>
        </tr>
        <tr class="MainContentList_ItemTR">
	        <td style="text-align:right">频道分类：</td>
	        <td><asp:DropDownList ID="ddlChannel" runat="server" EnableViewState="true"></asp:DropDownList><span class="NotesText"></span></td>
        </tr>
        <tr class="MainContentList_ItemTR">
	        <td style="text-align:right">相册说明：</td>
	        <td><asp:TextBox ID="tbDescription" runat="server" Height="80px" TextMode="MultiLine" Width="294px"  MaxLength="2000" EnableViewState="true"></asp:TextBox><span class="NotesText"></span></td>
        </tr>
        <tr class="MainContentList_ItemTR">
	        <td style="text-align:right">访问权限：</td>
	        <td>
	        <asp:RadioButtonList ID="rblViewStatus" runat="server" RepeatColumns="5" EnableViewState="true"></asp:RadioButtonList>
	        <span id="spanPassword" style="display:none;">访问密码:<asp:TextBox ID="tbPassword" runat="server" TextMode="Password" EnableViewState="true"></asp:TextBox></span>
	        </td>
        </tr>
        <tr class="MainContentList_ItemTR">
	        <td colspan="2"  style="text-align:center"><asp:Button ID="btnAlbumCreate" runat="server" OnClick="btnAlbumCreate_Click" Text="创建新相册" CssClass="SubmitButton"  EnableViewState="false" /></td>
        </tr>
    </table>
    <script type="text/javascript">
    function ShowViewStatus()
    {
        var ViewStatusSelect = document.getElementById("<%=rblViewStatus.ClientID%>");
        var spanPassword = document.getElementById("spanPassword");
        
        for(i=0;i<ViewStatusSelect.getElementsByTagName("INPUT").length;i++)   
        {
            if(ViewStatusSelect.getElementsByTagName("INPUT")[i].type=="radio")   
            {   
                if(ViewStatusSelect.getElementsByTagName("INPUT")[i].checked)
                {
                    if(ViewStatusSelect.getElementsByTagName("INPUT")[i].value == "1")
                    {
                        spanPassword.style.display = "";
                    }
                    else
                    {
                        spanPassword.style.display = "none";
                    }
                }
            }   
        }
    }
    ShowViewStatus();
    </script>
</asp:Panel>

<asp:Panel ID="plUploadPhoto" runat="server">
    <!--导航!-->
    <div id="AlbumAllPage_Nav" class="BrokenLineBox">
    <div class="LeftFloatBox"><a href="AlbumManage.aspx">我的相册</a> \ <a href="PhotoManage.aspx?AlbumID=<%=AlbumData.ID %>"><%=AlbumData.Title %></a> \ 上传相片</div>
    </div>
    
    <a href="Shoot.aspx">直接拍照</a>
    
    <!--相片上传!-->
    <script type="text/javascript">
    var UploadNum = 1;
    function ShowMoreFile()
    {
        if(UploadNum<5)
        {
            UploadNum++;
            var UploadSpan = document.getElementById("UploadSpan_" + UploadNum);
            UploadSpan.style.display="block";
        }
        ShowFileOper();
    }
    function ShowLessFile()
    {
        if(UploadNum>1)
        {
            var UploadSpan = document.getElementById("UploadSpan_" + UploadNum);
            UploadSpan.style.display="none";
            UploadNum--;
        }
        ShowFileOper();
    }
    function ShowFileOper()
    {
        if(UploadNum == 1)
        {
            document.getElementById("btnShowMoreFile").style.display="block";
            document.getElementById("btnShowLessFile").style.display="none";
        }
        else if(UploadNum == 5)
        {
            document.getElementById("btnShowMoreFile").style.display="none";
            document.getElementById("btnShowLessFile").style.display="block";
        }
        else
        {
            document.getElementById("btnShowMoreFile").style.display="block";
            document.getElementById("btnShowLessFile").style.display="block";
        }
        document.getElementById("UploadCount").value = UploadNum;
    }
    </script>
    <div id="UploadPanel">
        <div id="UploadTitle">上传：</div>
        <div id="UploadFileSelect">
            <input type="hidden" id="UploadCount" name="UploadCount" value="1" />
            <span id="UploadSpan_1" class="UploadSpan" style="display:block;"><input type="file" class="UploadInput" name="UploadFile_1" onchange="ShowMoreFileBox(this)" /></span>
            <span id="UploadSpan_2" class="UploadSpan" style="display:none;"><input type="file" class="UploadInput" name="UploadFile_2" /></span>
            <span id="UploadSpan_3" class="UploadSpan" style="display:none;"><input type="file" class="UploadInput" name="UploadFile_3" /></span>
            <span id="UploadSpan_4" class="UploadSpan" style="display:none;"><input type="file" class="UploadInput" name="UploadFile_4" /></span>
            <span id="UploadSpan_5" class="UploadSpan" style="display:none;"><input type="file" class="UploadInput" name="UploadFile_5" /></span>
        </div>
        <div id="ShowMoreFile" style="display:none;">
            <span id="btnShowMoreFile" style="display:block;"><a href="javascript:ShowMoreFile()">再添加一张</a></span>
            <span id="btnShowLessFile" style="display:none;"><a href="javascript:ShowLessFile()">减少一张</a></span>
        </div>
        <div>
        <div id="UploadPhotoTags">
            <span id="UploadPhotoTags_Title">为上传图片添加标签(Tags)：</span>
            <span id="UploadPhotoTags_Input"><asp:TextBox ID="tbTags" runat="server"></asp:TextBox></span>
            <span id="UploadPhotoTags_Memo">多个标签以“逗号”区分 </span>
        </div>
        </div>
        <div id="EnterUpload">
        <asp:Button ID="btUpload" runat="server" Text="确定" OnClick="btUpload_Click"  EnableViewState="false" />
        <button onclick="location='PhotoManage.aspx?AlbumID=<%=AlbumData.ID %>'">取消</button>
        </div>
    </div>
    <script type="text/javascript">
    function ShowMoreFileBox(obj)
    {
        if(obj.value != "")
        {
            document.getElementById("ShowMoreFile").style.display = "";
        }
    }
    </script>
</asp:Panel>
    
</div>
</form>
</asp:Content>