﻿<%@ Page Language="C#" MasterPageFile="../BloggerAdmin.master" AutoEventWireup="true" CodeBehind="PhotoEdit.aspx.cs" Inherits="Y10.WebSite.Blog.Blogger.Admin.Album.PhotoEdit" %>
<%@ Register Assembly="System.Web.Extensions" Namespace="System.Web.UI" TagPrefix="asp" %>
<asp:Content ID="Content1" ContentPlaceHolderID="phHead" runat="server">
<link href="<%=AppUrl %>/Blogger/Admin/Album/Images/Style/Album.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphMainAdmin" runat="server">
<form id="MainForm" runat="server">
<!--Ajax脚本管理器-->
<asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
<!--修改Ajax的initialAction-->
<script type="text/javascript">
Sys.Application.add_load(function()
{
    var form = Sys.WebForms.PageRequestManager.getInstance()._form;
    var href = window.location.href;
    form._initialAction = form.action = href;
});
</script>
<!--Ajax进度显示器-->
<asp:UpdateProgress ID="UpdateProgress1" runat="server">
<ProgressTemplate>
<div style="border: 1px solid #DCBE6E;background: #FFFFBF;padding: 5px; position:absolute; left:5px; bottom:5px;">任务处理中,请稍候...</div>
</ProgressTemplate>
</asp:UpdateProgress>

<div id="ContentTitle"><%=MyTitle %></div>
<div id="ContentBody">

    <!--当前相片导航!-->
    <asp:UpdatePanel ID="NavUpdatePanel" runat="server" UpdateMode="Conditional">
    <Triggers>
    <asp:PostBackTrigger ControlID="btnGoPhoto"/>
    <asp:AsyncPostBackTrigger ControlID="btSaveTitle" EventName="Click" />
    <asp:AsyncPostBackTrigger ControlID="btUpdateAlbumID" EventName="Click" />
    </Triggers>
    <ContentTemplate>
    <div id="AlbumAllPage_Nav" class="BrokenLineBox">
    <span><a href="AlbumManage.aspx">我的相册</a> \ <a href="PhotoManage.aspx?AlbumID=<%=ViewState["AlbumID"] %>"><%=ViewState["AlbumTitle"] %></a> \ <a href="PhotoView.aspx?PhotoID=<%=PhotoData.ID %>"><%=PhotoData.Title%></a></span>
    </div>
    </ContentTemplate>
    </asp:UpdatePanel>
    
    <!--左侧相片主体信息!-->
    <fieldset id="PhotoMainBox" class="Fieldset01">

        <!--相片标题!-->
        <asp:UpdatePanel ID="TitleUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
            <div id="Title_View" class="ViewPanel" style="text-align:center;" onclick="Hide('Title_View');Hide('Title_Edit');" title="单击可修改相片标题"><%=PhotoData.Title %></div>
            <div id="Title_Edit" class="EditPanel" style="display:none; text-align:center;">
            <div class="EditPanel_Input"><asp:TextBox ID="tbTitle" runat="server" style="width:200px;"></asp:TextBox></div>
            <div class="EditPanel_Button">
            <asp:Button ID="btSaveTitle" runat="server" CssClass="btnSubmit02" OnClick="btUpdateTitle_Click" /><input id="btCancelEditTitle" type="button" class="btnCancel02" onclick="Hide('Title_View');Hide('Title_Edit');" />
            </div>
            </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>

        <!--相片本身!-->
        <div id="PhotoImageBox">
        <img id="PhotoImage" alt="<%=PhotoData.Title %>" src="<%=Ruiao.Album.Common.Helper.GetPhotoUrl(PhotoData.FilePath, false)%>" onload="ImgAutoResize(this, 600, 400)" />
        </div>
        
        <!--访问状态!-->
        <asp:UpdatePanel ID="ViewStatusUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_LeftTitle">访问状态:</div>
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
        <div id="ViewStatus_View" class="ViewPanel" onclick="Hide('ViewStatus_View');Hide('ViewStatus_Edit');" title="单击可修改相片访问权限"><%=ViewState["ViewStatusDisplay"]%></div>
        <div id="ViewStatus_Edit" class="EditPanel" style="display:none;">
        <div class="EditPanel_Input">
        <asp:RadioButtonList ID="rblViewStatus" runat="server" RepeatColumns="5"></asp:RadioButtonList>
        <span id="spanPassword">访问密码:<asp:TextBox ID="tbPassword" runat="server" TextMode="Password"></asp:TextBox></span>
        </div>
        <div class="EditPanel_Button">
        <asp:Button ID="btUpdateViewStatus" runat="server" CssClass="btnSubmit02" OnClick="btUpdateViewStatus_Click" /><input id="btCancelEditViewStatus" type="button" class="btnCancel02" onclick="Hide('ViewStatus_View');Hide('ViewStatus_Edit');" />
        </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>
        <script type="text/javascript">
        function ShowViewStatus()
        {
            var ViewStatusSelect = document.getElementById("<%=rblViewStatus.ClientID%>");
            var spanPassword = document.getElementById("spanPassword");
            
            for(i=0;i<ViewStatusSelect.getElementsByTagName("INPUT").length;i++)   
            {
                if(ViewStatusSelect.getElementsByTagName("INPUT")[i].type=="radio")   
                {   
                    if(ViewStatusSelect.getElementsByTagName("INPUT")[i].checked)
                    {
                        if(ViewStatusSelect.getElementsByTagName("INPUT")[i].value == "1")
                        {
                            spanPassword.style.display = "";
                        }
                        else
                        {
                            spanPassword.style.display = "none";
                        }
                    }
                }   
            }
        }
        ShowViewStatus();
        </script>
        
        <!--相片说明!-->
        <asp:UpdatePanel ID="DescriptionUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
            <div id="Descriptio_View" class="ViewPanel" onclick="Hide('Descriptio_View');Hide('Descriptio_Edit');" title="单击可修改相片说明"><%=ViewState["PhotoDescriptionDisplay"]%></div>
            <div id="Descriptio_Edit" class="EditPanel" style="display:none;">
            <div class="EditPanel_Input" style="width:90%;">
            <asp:TextBox ID="tbDescription" runat="server" TextMode="MultiLine" style="width:100%; height:60px;"></asp:TextBox>
            </div>
            <div class="EditPanel_Button">
            <asp:Button ID="btUpdateDescription" runat="server" CssClass="btnSubmit02" OnClick="btUpdateDescription_Click" /><input id="btCancelEditDescription" type="button" class="btnCancel02" onclick="Hide('Descriptio_View');Hide('Descriptio_Edit');" />
            </div>
            </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>
        
        <!--跳转导航!-->
        <div id="PhotoNav">
            <span id="PhotoNum"><%=brPhoto.IndexOf(PhotoData.AlbumID, PhotoData.ID)+1 %> / <%=brPhoto.RecordCount(PhotoData.AlbumID, MyBlogData.ID, -1) %> 张</span>
            <span id="DoPreNext"><a href="PhotoEdit.aspx?PhotoID=<%=brPhoto.GetPreNextID(PhotoData.AlbumID, PhotoData.ID, false, true)%>">上一张</a> <a href="PhotoEdit.aspx?PhotoID=<%=brPhoto.GetPreNextID(PhotoData.AlbumID, PhotoData.ID, true, true)%>">下一张</a></span>
            <span id="GoPhoto">跳到<asp:TextBox ID="tbGoPhotoNum" runat="server" CssClass="tbGoPhotoNum"></asp:TextBox>张<asp:Button ID="btnGoPhoto" runat="server" OnClick="btnGoPhoto_Click" CssClass="btnGoPhoto" /></span>
        </div>
    </fieldset>
    
    <div id="PhotoOtherInfoBox" class="LeftFloatBox">

        <!--所属相册!-->
        <asp:UpdatePanel ID="AlbumIDUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_LeftTitle">所属相册:</div>
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
        <div id="AlbumID_View" class="ViewPanel" onclick="Hide('AlbumID_View');Hide('AlbumID_Edit');" title="单击可修改相片所属相册"><%=ViewState["AlbumTitle"] %></div>
        <div id="AlbumID_Edit" class="EditPanel" style="display:none;">
        <div class="EditPanel_Input">
        <asp:DropDownList runat="server" id="ddlAlbumID"></asp:DropDownList>
        </div>
        <div class="EditPanel_Button">
        <asp:Button ID="btUpdateAlbumID" runat="server" CssClass="btnSubmit02" OnClick="btUpdateAlbumID_Click" /><input id="btCancelEditAlbumID" type="button" class="btnCancel02" onclick="Hide('AlbumID_View');Hide('AlbumID_Edit');" />
        </div>
        </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>

        <!--所属频道!-->
        <asp:UpdatePanel ID="ChannelIDUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_LeftTitle">所属频道:</div>
        <div class="ViewEditPanel_onmouseout" onmouseover="this.className='ViewEditPanel_onmouseover';" onmouseout="this.className='ViewEditPanel_onmouseout';">
        <div id="ChannelID_View" class="ViewPanel" onclick="Hide('ChannelID_View');Hide('ChannelID_Edit');" title="单击可修改相片所属频道"><%=ViewState["ChannelDisplayName"]%></div>
        <div id="ChannelID_Edit" class="EditPanel" style="display:none;">
        <div class="EditPanel_Input">
        <asp:DropDownList runat="server" id="ddlChannelID"></asp:DropDownList>
        </div>
        <div class="EditPanel_Button">
        <asp:Button ID="btUpdateChannelID" runat="server" CssClass="btnSubmit02" OnClick="btUpdateChannelID_Click" /><input id="btCancelEditChannelID" type="button" class="btnCancel02" onclick="Hide('ChannelID_View');Hide('ChannelID_Edit');" />
        </div>
        </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>
        
        <!--其他信息!-->
        <asp:UpdatePanel ID="OtherInfoUpdatePanel" runat="server" UpdateMode="Conditional">
        <Triggers>
            <asp:PostBackTrigger ControlID="imgDeletePhoto"/>
        </Triggers>
        <ContentTemplate>
        <div class="FullWidthBox">
        <div class="LeftFloatPanel" style="margin-left:1px;">上传时间:</div>
        <div class="LeftFloatPanel" style="margin-left:3px;"><%=PhotoData.AddTime %></div>
        </div>
        <div>
        <asp:ImageButton ID="imgDeletePhoto" runat="server" ImageUrl="/Blogger/Admin/Album/Images/icon_PhotoDelete.gif" alt="删除该相片" OnClick="imgDeletePhoto_Click" />
        <asp:ImageButton ID="imgSetCover" runat="server" ImageUrl="/Blogger/Admin/Album/Images/SetCover.gif" alt="设置该相片为相册封面" OnClick="imgSetCover_Click" />
        <a target="_blank" href="<%=Ruiao.Album.Common.Helper.GetPhotoUrl(PhotoData.FilePath, false)%>"><img alt="查看相片原图" src="/Blogger/Admin/Album/Images/icon_PhotoView.gif" /></a>
        <span onclick="copyUrl(window.location.href)"><img style="cursor:pointer" alt="复制该相片网址" src="/Blogger/Admin/Album/Images/icon_Copyurl.gif" /></span>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>
        
        <!--间隔线!-->
        <div class="BrokenLine"></div>

        <!--相片标签!-->
        <asp:UpdatePanel ID="TagsUpdatePanel" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        <div style="width:320px;" class="ViewEditPanelBox">
        标签(Tags)： <br />
        <asp:Repeater ID="rpTags" runat="server">
        <ItemTemplate>
        <%#Container.DataItem%> <asp:ImageButton ID="imgbtnTagDelete" runat="server" ImageUrl="/Blogger/Admin/Album/Images/DeleteSmallIcon.gif" OnClick="imgbtnTagDelete_Click" CommandArgument="<%#Container.DataItem%>" title="删除该标签(Tag)" /><br />
        </ItemTemplate>
        </asp:Repeater>
        <div class="ViewEditPanelBox">
        <div class="ViewEditPanel_onmouseout">
        <div id="AddTag_View" class="ViewPanel" onclick="Hide('AddTag_View');Hide('AddTag_Edit');"><img alt="添加标签(Tag)" src="/Blogger/Admin/Album/Images/AddTag.gif" /></div>
        <div id="AddTag_Edit" class="EditPanel" style="display:none;">
        <div class="EditPanel_Input">
        <asp:TextBox ID="tbTag" runat="server"></asp:TextBox>
        </div>
        <div class="EditPanel_Button">
        <asp:Button ID="btnAddTag" runat="server" CssClass="btnSubmit02" OnClick="btnAddTag_Click" /><input id="btCancelAddTag" type="button" class="btnCancel02" onclick="Hide('AddTag_View');Hide('AddTag_Edit');" />
        </div>
        </div>
        </div>
        </div>
        </div>
        </ContentTemplate>
        </asp:UpdatePanel>
    
    </div>
    
</div>
</form>
</asp:Content>
