﻿<%@ Page Language="C#" MasterPageFile="../Blogger.master" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="Y10.WebSite.Blog.Blogger.Album.List" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<asp:Content ID="Content1" ContentPlaceHolderID="phHead" runat="server">
<link href="<%=AppUrl %>/Skins/<%=SkinInfo.SkinPath%>/Album/Album.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphMain" runat="server">

<!--主体容器-->
<div id="BodyContainer">

    <!--主要内容部分-->
    <div id="ContentContainer">
    <div id="innerContentContainer">
    
    <!--主表单-->
    <form id='MainForm' runat="server">
    
        <!--最新相册列表-->
        <div id="AlbumList" class="ListBox_Normal">
            <div class="BoxTitle">
                <div class="BoxTitle_Left"><a><span>相册列表</span></a></div>
                <div class="BoxTitle_Right"></div>
            </div>
            <div class="BoxBody">
            
                <!--上分页-->
                <div id="AlbumListTopPager" class="Pager">
                <webdiyer:AspNetPager ID="TopPager" runat="server" OnPageChanged="TopPager_PageChanged" AlwaysShow="True" UrlPaging="True" />
                </div>
                
                <ul id="AlbumItemList">
                <asp:Repeater ID="rpAlbumList" runat="server" OnItemCreated="rpAlbumList_ItemCreated">
                <ItemTemplate>
                <li class="AlbumItem">
                    <div class="AlbumItem_Cover"><table><tr><td><a href="<%=MyBloggerUrl %>/Album/<%# DataBinder.Eval(Container, "DataItem.ID")%>/Default<%=ExtensionName %>"><img alt="<%# DataBinder.Eval(Container, "DataItem.Title")%>" src="<%# CoverPhoto %>" /></a></td></tr></table></div>
                    <div class="AlbumItem_Info">
                        <div class="AlbumItem_Top">
                            <h1 class="AlbumItem_Title"><a href="<%=MyBloggerUrl %>/Album/<%# DataBinder.Eval(Container, "DataItem.ID")%>/Default<%=ExtensionName %>"><%# DataBinder.Eval(Container, "DataItem.Title")%></a></h1>
                            <span class="AlbumItem_ViewMode"><%#ViewStatusIcon %></span>
                        </div>
                        <h3 class="AlbumItem_Description"><%#AlbumDescription %></h3>
                        <span class="AlbumItem_PhotoNumber"><%#PhotoNum %>张</span>
                    </div>
                </li>
                </ItemTemplate>
                <SeparatorTemplate><li class="AlbumItem_Separator"><div></div></li></SeparatorTemplate>
                </asp:Repeater>
                </ul>
                
                <!--下分页-->
                <div id="AlbumListBottomPager" class="Pager">
                <webdiyer:AspNetPager ID="BottomPager" runat="server" OnPageChanged="BottomPager_PageChanged" AlwaysShow="True" UrlPaging="True"  />
                </div>
        
			</div>
			<div class="BoxBottom"></div>
        </div>
        
    </form>
    
    </div>
    </div>
    
    <!--侧边栏-->
    <div id="Sidebar">
        <div id="Sidebar_Top"></div>
        <div id="Sidebar_Body"><asp:PlaceHolder ID="phSidebar" runat="server"></asp:PlaceHolder></div>
        <div id="Sidebar_Bottom"></div>
    </div>
    
</div>
</asp:Content>
