﻿<%@ Page Language="C#" MasterPageFile="../Blogger.master" AutoEventWireup="true" CodeBehind="PhotoView.aspx.cs" Inherits="Y10.WebSite.Blog.Blogger.Admin.Album.PhotoView" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="cc1" %>
<%@ Register Src="../Module/CommentAdd.ascx" TagName="CommentAdd" TagPrefix="uc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="phHead" runat="server">
<link href="<%=AppUrl %>/Skins/<%=SkinInfo.SkinPath%>/Album/Album.css" rel="stylesheet" type="text/css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="cphMain" runat="server">

<!--主体容器-->
<div id="BodyContainer">

    <!--主要内容部分-->
    <div id="ContentContainer">
    <div id="innerContentContainer">
    
    <!--主表单-->
    <form id='MainForm' runat="server">
        
        <!--相片主体信息!-->
        <div id="PhotoInfo" class="MainContent_Container">
        
            <!--导航-->
            <div id="AlbumNav" class="ContentBox_Normal">
                <a href="<%=MyBloggerUrl %>/Album/Default.aspx"><span>我的相册</span></a>
                <a><span>\</span></a>
                <a href="<%=MyBloggerUrl %>/Album/<%=AlbumData.ID %>/Default.aspx"><span><%=AlbumData.Title %></span></a>
                <a><span>\</span></a>
                <a><span><%=PhotoData.Title%></span></a>
            </div>
            
            <!--分隔线-->
            <hr id="TopLine" class="BlackLine" />
        
            <div id="PhotoMainBox">
            
                <!--相片顶部!-->
                <div id="PhotoHeader">
                    <div id="PhotoNav">
                        <span id="DoPrevious"><a href="<%=MyBloggerUrl %>/Album/<%=AlbumData.ID %>/<%=brPhoto.GetPreNextID(PhotoData.AlbumID, PhotoData.ID, false, true)%>.aspx">上一张</a></span>
                        <span id="PhotoNum">
                            <a id="CurrentNum"><span><%=brPhoto.IndexOf(PhotoData.AlbumID, PhotoData.ID)+1 %></span></a>
                            <a><span>/</span></a>
                            <a id="Sum"><span><%=brPhoto.RecordCount(PhotoData.AlbumID, MyBlogData.ID, -1) %></span></a>
                            <a><span>张</span></a>
                        </span>
                        <span id="DoNext"><a href="<%=MyBloggerUrl %>/Album/<%=AlbumData.ID %>/<%=brPhoto.GetPreNextID(PhotoData.AlbumID, PhotoData.ID, true, true)%>.aspx">下一张</a></span>
                        <span id="GoPhoto">跳到<asp:TextBox ID="tbGoPhotoNum" runat="server" CssClass="tbGoPhotoNum"></asp:TextBox>张<asp:Button ID="btnGoPhoto" runat="server" OnClick="btnGoPhoto_Click" CssClass="btnGoPhoto" /></span>
                    </div>
                </div>
                
                <!--相片本身!-->
                <script type="text/javascript">
                function PhotoImageResize(obj)
                {
                    var objPhotoImageBox = document.getElementById("PhotoImageBox");
                    var Width = objPhotoImageBox.offsetWidth * 0.98;
                    var Height = objPhotoImageBox.offsetHeight * 0.98;
                    ImgAutoResize(obj, Width, Height);
                }
                </script>
                <div id="PhotoImageBox">
                <table><tr><td>
                <img id="PhotoImage" alt="<%=PhotoData.Title %>" src="<%=Ruiao.Album.Common.Helper.GetPhotoUrl(PhotoData.FilePath, false)%>" onload="PhotoImageResize(this)" />
                <div id="Title"><a><span><%=PhotoData.Title%></span></a></div>
                <%if(!String.IsNullOrEmpty(PhotoData.Description)){%><div id="Description"><a><span><%=PhotoData.Description%></span></a></div><%}%>
                </td></tr></table>
                </div>
                
                <!--与朋友分享!-->
                <div id="Shares">
                    <dl id="ShareInfo_PhotoUrl"><dt>取得该图的地址:</dt><dd><input id="tbShareInfo_PhotoUrl" type="text" value="<%=MyBloggerUrl %>/Album/<%=AlbumData.ID %>/<%=PhotoData.ID %>.aspx" /><button onclick="copyUrl(document.getElementById('tbShareInfo_PhotoUrl').value), '图片地址已复制到剪切板'"><span>复制</span></button></dd></dl>
                    <dl id="ShareInfo_UBBCode"><dt>取得贴图的论坛代码:</dt><dd><input id="tbShareInfo_UBBCode" type="text" value="[img]<%=MyBloggerUrl %>/Album/PhotoFiles/Normal/<%=PhotoData.ID %>.aspx[/img]" /><button onclick="copyUrl(document.getElementById('tbShareInfo_UBBCode').value), '该图片的UBB代码已复制到剪切板,请在需要使用的帖子中粘贴即可:)'"><span>复制</span></button></dd></dl>
                    <dl id="ShareInfo_HtmlCode"><dt>取得贴图的博客代码:</dt><dd><input id="tbShareInfo_HtmlCode" type="text" value="&lt;img alt=&quot;<%=PhotoData.Title %>&quot; src=&quot;<%=MyBloggerUrl %>/Album/PhotoFiles/Normal/<%=PhotoData.ID %>.aspx&quot; /&gt;" /><button onclick="copyUrl(document.getElementById('tbShareInfo_HtmlCode').value, '该图片的HTML代码已复制到剪切板,请粘贴到您要发表的博客中:)')"><span>复制</span></button></dd></dl>
                </div>
            
            </div>
            
            <!--评论列表-->
            <asp:PlaceHolder ID="phCommentList" runat="server"></asp:PlaceHolder>

            <!--发表评论-->
            <asp:PlaceHolder ID="phCommentAdd" runat="server"></asp:PlaceHolder>
            
        </div>

    </form>
    
    </div>
    </div>
    
    <!--侧边栏-->
    <div id="Sidebar">
        <div id="Sidebar_Top"></div>
        <div id="Sidebar_Body"><asp:PlaceHolder ID="phSidebar" runat="server"></asp:PlaceHolder></div>
        <div id="Sidebar_Bottom"></div>
    </div>
    
</div>
</asp:Content>