﻿<%@ Page Language="C#" MasterPageFile="Blogger.master" AutoEventWireup="true" CodeBehind="GuestBook.aspx.cs" Inherits="Ruiao.WebSite.Blogger.GuestBook" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="cc1" %>
<asp:Content ID="MyContent" ContentPlaceHolderID="cphMain" Runat="Server">

<!--主体部分-->
<div id="BodyContainer">

    <!--主要内容部分-->
    <div id="ContentContainer">
    <div id="innerContentContainer">
    
        <!--主表单-->
        <form id='MainForm' runat="server">
        
        <!--留言列表-->
        <div id="GuestBook" class="ListBox_Normal">
            <div class="BoxTitle">
                <div class="BoxTitle_Left"><a><span>留言列表</span></a></div>
                <div class="BoxTitle_Right">
                <%if(IsBlogOwnerMember) {%>
                    <span id="GotoAll"><a href="<%=MyBloggerUrl %>/GuestBook/All<%=ExtensionName %>">所有留言</a></span>
                    <span id="GotoPrivate"><a href="<%=MyBloggerUrl %>/GuestBook/Private<%=ExtensionName %>">私人留言</a></span>
                    <span id="GotoPublic"><a href="<%=MyBloggerUrl %>/GuestBook/Public<%=ExtensionName %>">公开留言</a></span>
                <%} %>
                </div>
            </div>
            <div class="BoxBody">
                <ol>
                <asp:Repeater ID="rpGuestBookList" runat="server" OnItemCreated="rpGuestBookList_ItemCreated">
                <ItemTemplate>
                <li id="GuestBookItem_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="GuestBookItem_<%# ((int)DataBinder.Eval(Container, "ItemIndex")%2==0)?"A":"B" %>">
                    <div class="GuestBookTop">
                        <span class="GuestBookTop_Left"></span>
                        <h3 class="GuestBookTop_Title"><%# DataBinder.Eval(Container, "DataItem.Title") %></h3>
                        <span class="GuestBookTop_Author"><%# AuthorHtml %></span>
                        <span class="GuestBookTop_PostTime">[<%# DataBinder.Eval(Container, "DataItem.AddTime").ToString() %>]</span>
                        <%if(IsBlogOwnerMember) {%>
                        <span class="GuestBookTop_Edit"><a href="<%=MyBloggerUrl %>/Admin/GuestBook/GuestBookEdit<%=ExtensionName %>?GuestBookID=<%# DataBinder.Eval(Container, "DataItem.ID") %>">修改</a></span>
                        <span class="GuestBookTop_Delete"><a href="<%=MyBloggerUrl %>/Admin/GuestBook/GuestBookOperation<%=ExtensionName %>?Action=Delete&GuestBookID=<%# DataBinder.Eval(Container, "DataItem.ID") %>">删除</a></span>
                        <%} %>
                        <span class="GuestBookTop_Right"></span>
                    </div>
                    <div id="GuestBookContent_<%# DataBinder.Eval(Container, "DataItem.ID") %>" class="GuestBookContent">
                        <%# Ruiao.Common.Helper.Text.UBB2Html(DataBinder.Eval(Container, "DataItem.Body").ToString(), AppUrl, MyBlogData.CommentUBB) %>
                    </div>
                </li>
                </ItemTemplate>
                <SeparatorTemplate><li class="GuestBookItem_Separator"><div /></li></SeparatorTemplate>
                </asp:Repeater>
                </ol>
                <div id="GuestBookListBottomPager" class="Pager"><cc1:aspnetpager id="Pager" runat="server" AlwaysShow="True" UrlPaging="True" ></cc1:aspnetpager></div>
            </div>
            <div class="BoxBottom"></div>
        </div>
        
        <!--写新留言-->
        <div id="WriteGuestBook" class="FormBox_Normal">
            <div class="BoxTitle">
                <div class="BoxTitle_Left"></div>
                <div class="BoxTitle_Center"><a><span>写新留言</span></a></div>
                <div class="BoxTitle_Right"></div>
            </div>
            <div class="BoxBody">
                <dl id="AuthorName_InputItem" class="FormItem"><dt>评论者:</dt><dd><asp:TextBox ID="tbAuthorName" runat="server"></asp:TextBox><asp:CheckBox ID="cbxIsAnonymous" runat="server" Text="匿名" /><asp:CheckBox ID="cbxIsPrivate" runat="server" Text="悄悄话" /></dd></dl>
                <dl id="AuthorMail_InputItem" class="FormItem"><dt>信箱:</dt><dd><asp:TextBox ID="tbAuthorMail" runat="server"></asp:TextBox></dd></dl>
                <dl id="AuthorUrl_InputItem" class="FormItem"><dt>主页:</dt><dd><asp:TextBox ID="tbAuthorUrl" runat="server"></asp:TextBox></dd></dl>
                <dl id="Title_InputItem" class="FormItem"><dt>标题:</dt><dd><asp:TextBox ID="tbTitle" runat="server"></asp:TextBox></dd></dl>
                <dl id="Body_InputItem" class="FormItem"><dt>内容:</dt><dd><asp:TextBox ID="tbBody" runat="server" TextMode="MultiLine" ></asp:TextBox></dd></dl>
                <span id="SaveButton"><asp:Button ID="btSave" runat="server" OnClick="btSave_Click" Text="书写留言" /></span>
            </div>
            <div class="BoxBottom"></div>
        </div>
        </form>
    
    </div>
    </div>
    
    <!--侧边栏-->
    <div id="Sidebar">
        <div id="Sidebar_Top"></div>
        <div id="Sidebar_Body"><asp:PlaceHolder ID="phSidebar" runat="server"></asp:PlaceHolder></div>
        <div id="Sidebar_Bottom"></div>
    </div>
    
</div>

</asp:Content>