﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="Ruiao.WebSite.Blogger.Module.CategoryList" Codebehind="CategoryList.ascx.cs" %>
<asp:Repeater ID="rpCategory" runat="server" OnItemCreated="rpCategory_ItemCreated">
<HeaderTemplate>
<div id="Side_CategoryList" class="SidePanel">
    <h4 class="SidePanel_Title"><span><%=Title %></span></h4>
    <div class="SidePanel_Body">
    <div class="SideBody_Header"><%=HeaderTemplate%></div>
    <div class="SideBody_Content">
    <ul>
        <li id="SideItem_NonCategory" class="SideItem">
            <span class="SideCategory_Text"><a href="<%=MyPage.MyBloggerUrl %>/Category/ArticleList<%=MyPage.ExtensionName %>" title="所有没有分类的日志">未分类</a></span>
            <span class="SideCategory_RSS2"><a href="<%=MyPage.MyBloggerUrl %>/RSS2<%=MyPage.ExtensionName %>?CategoryID=0"><img src="<%=MyPage.AppUrl %>/Skins/<%=MyPage.SkinInfo.SkinPath %>/icon_rss.png" alt="获取未分类日志的RSS(2.0)日志聚合" /></a></span>
        </li>
</HeaderTemplate>
<ItemTemplate>
        <li id="SideItem_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="SideItem">
            <span class="SideCategory_Image"><%#IconHtml%></span>
            <span class="SideCategory_Text"><a href="<%=MyPage.MyBloggerUrl %>/Category/<%# DataBinder.Eval(Container, "DataItem.Name")%>/ArticleList<%=MyPage.ExtensionName %>" title="<%# DataBinder.Eval(Container, "DataItem.Description")%>"><%# DataBinder.Eval(Container, "DataItem.DisplayName")%></a></span>
            <span class="SideCategory_RSS2"><a href="<%=MyPage.MyBloggerUrl %>/RSS2<%=MyPage.ExtensionName %>?CategoryName=<%# DataBinder.Eval(Container, "DataItem.Name")%>"><img src="<%=MyPage.AppUrl %>/Skins/<%=MyPage.SkinInfo.SkinPath %>/icon_rss.png" alt="获取该分类日志的RSS(2.0)日志聚合" /></a></span>
        </li>
</ItemTemplate>
<SeparatorTemplate><li class="SideItem_Separator"><%=SeparatorTemplate%></li></SeparatorTemplate>
<FooterTemplate>
    </ul>
    </div>
    <div class="SideBody_Footer"><%=FooterTemplate%></div>
    </div>
    <div class="SidePanel_Buttom"></div>
</div>
</FooterTemplate>
</asp:Repeater>