﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CommentList.ascx.cs" Inherits="Ruiao.WebSite.Blogger.Module.CommentList" %>
<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="cc1" %>
<!--评论部分-->
<a id="CommentTop" name="CommentTop" href="#CommonTop"></a><!--评论顶部放此标志方便其他页面直接跳移到评论处使用-->
<div id="CommentList" class="ListBox_Normal">
    <div class="BoxTitle">
        <div class="BoxTitle_Left"><a><span>相关评论</span></a></div>
        <div class="BoxTitle_Right"></div>
    </div>
    <div class="BoxBody">
        <ol id="CommentItemList">
        <asp:Repeater ID="rpComment" runat="server" OnItemCreated="rpComment_ItemCreated">
        <ItemTemplate>
            <li id="CommentItem_<%# DataBinder.Eval(Container, "ItemIndex") %>" class="CommentItem_<%# ((int)DataBinder.Eval(Container, "ItemIndex")%2==0)?"A":"B" %>">
                <div class="CommentTop">
                    <span class="CommentTop_Quote"><img alt="" src="<%=MyPage.AppUrl %>/Skins/<%=MyPage.SkinInfo.SkinPath %>/icon_quote.gif" /></span>
                    <span class="CommentTop_Title"><%# DataBinder.Eval(Container, "DataItem.Title") %></span></a>
                    <span class="CommentTop_Author"> -- <%# AuthorHtml %></span>
                    <span class="CommentTop_PostTime">[<%# DataBinder.Eval(Container, "DataItem.AddTime").ToString() %>]</span>
                </div>
                <div id="CommentContent_<%# DataBinder.Eval(Container, "DataItem.ID") %>" class="CommentContent">
                <%# Ruiao.Common.Helper.Text.UBB2Html(DataBinder.Eval(Container, "DataItem.Body").ToString(), MyPage.AppUrl, MyPage.MyBlogData.CommentUBB)%>
                </div>
            </li>
        </ItemTemplate>
        <SeparatorTemplate><li class="CommentItem_Separator"><div /></li></SeparatorTemplate>
        </asp:Repeater>
        </ol>
        <div id="CommentListBottomPager" class="Pager"><cc1:aspnetpager id="Pager" runat="server" AlwaysShow="True" UrlPaging="True"></cc1:aspnetpager></div>
    </div>
    <div class="BoxBottom"></div>
</div>